/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util.io.filter;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class AndFileFilter
implements FileFilter {
    private List<FileFilter> ex;

    public AndFileFilter(List<FileFilter> ex) {
        this.ex = new ArrayList<FileFilter>(ex);
    }

    public AndFileFilter(FileFilter ... filters) {
        this(Arrays.asList(filters));
    }

    @Override
    public boolean accept(File pathname) {
        for (FileFilter f : this.ex) {
            if (f.accept(pathname)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder b = new StringBuilder("(");
        String s = "";
        for (FileFilter f : this.ex) {
            b.append(s).append(f.toString());
            s = "&";
        }
        return b.append(")").toString();
    }
}

