/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util.io;

import java.util.ArrayList;
import net.morilib.range.CharSetException;
import net.morilib.range.CharSets;
import net.morilib.range.Range;
import net.morilib.util.bit.BitVector;
import net.morilib.util.bit.PackedBitVector;
import net.morilib.util.io.filter.WildcardSyntaxException;
import net.morilib.util.primitive.IntegerCollection;
import net.morilib.util.primitive.IntegerHashSet;
import net.morilib.util.primitive.iterator.IntegerIterator;

public class Wildcard {
    private Range[] chars;
    private BitVector repeat;

    private Wildcard(Range[] chars, BitVector repeat) {
        this.chars = chars;
        this.repeat = repeat;
    }

    public boolean matches(CharSequence cs) {
        IntegerHashSet ss = new IntegerHashSet();
        IntegerHashSet ad = new IntegerHashSet();
        ss.add(false);
        int p = 0;
        while (p < cs.length()) {
            IntegerIterator i = ss.intIterator();
            char c = cs.charAt(p);
            while (i.hasNext()) {
                int s = i.next();
                if (this.chars[s].contains(c)) {
                    ad.add(s + 1);
                }
                if (this.repeat.getBoolean(s)) continue;
                i.remove();
            }
            ss.addAllInt((IntegerCollection)ad);
            ad.clear();
            if (ss.isEmpty()) break;
            ++p;
        }
        return ss.contains(this.chars.length - 1);
    }

    public static Wildcard compile(CharSequence pt) {
        ArrayList<Range> rl = new ArrayList<Range>();
        PackedBitVector rp = new PackedBitVector();
        boolean b = true;
        int p = 0;
        while (p < pt.length()) {
            char c = pt.charAt(p);
            switch (c) {
                case '*': {
                    if (b) {
                        rp.add(true);
                    }
                    b = false;
                    break;
                }
                case '?': {
                    rl.add(CharSets.ALL_CHAR);
                    if (b) {
                        rp.add(false);
                    }
                    b = true;
                    break;
                }
                case '[': {
                    int z = p + 1;
                    while (true) {
                        if (z >= pt.length()) {
                            throw new WildcardSyntaxException();
                        }
                        if (pt.charAt(z) == ']') break;
                        ++z;
                    }
                    try {
                        rl.add(CharSets.parse(pt.subSequence(p + 1, z)));
                    }
                    catch (CharSetException e) {
                        throw new WildcardSyntaxException(e);
                    }
                    if (b) {
                        rp.add(false);
                    }
                    b = true;
                    p = z;
                    break;
                }
                default: {
                    rl.add(CharSets.newCharInterval(c));
                    if (b) {
                        rp.add(false);
                    }
                    b = true;
                }
            }
            ++p;
        }
        if (b) {
            rp.add(false);
        }
        rl.add(Range.O);
        return new Wildcard(rl.toArray(new Range[0]), rp);
    }

    public static boolean matches(CharSequence pt, CharSequence cs) {
        return Wildcard.compile(pt).matches(cs);
    }
}

