/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util.io;

import java.io.File;

public final class Files {
    private Files() {
    }

    public static boolean chmod(File f, String s) {
        boolean val;
        boolean own;
        if (s == null) {
            throw new NullPointerException();
        }
        if (s.length() != 3) {
            throw new IllegalArgumentException();
        }
        char[] cs = s.toCharArray();
        switch (cs[0]) {
            case 'u': {
                own = true;
                break;
            }
            case 'a': {
                own = false;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        switch (cs[1]) {
            case '+': {
                val = true;
                break;
            }
            case '-': {
                val = false;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        switch (cs[2]) {
            case 'r': {
                return f.setReadable(val, own);
            }
            case 'w': {
                return f.setWritable(val, own);
            }
            case 'x': {
                return f.setExecutable(val, own);
            }
        }
        throw new IllegalArgumentException();
    }

    private static boolean _chmoda(File f, boolean x, boolean w, boolean r) {
        boolean z = f.setReadable(r, false);
        z &= f.setWritable(w, false);
        return z &= f.setExecutable(x, false);
    }

    private static boolean _chmodu(File f, boolean x, boolean w, boolean r) {
        boolean z = f.setReadable(r, true);
        z &= f.setWritable(w, true);
        return z &= f.setExecutable(x, true);
    }

    public static boolean chmod(File f, int v) {
        boolean r;
        if (v < 0 || v > 77) {
            throw new IllegalArgumentException();
        }
        switch (v % 10) {
            case 0: {
                r = Files._chmoda(f, false, false, false);
                break;
            }
            case 1: {
                r = Files._chmoda(f, true, false, false);
                break;
            }
            case 2: {
                r = Files._chmoda(f, false, true, false);
                break;
            }
            case 3: {
                r = Files._chmoda(f, true, true, false);
                break;
            }
            case 4: {
                r = Files._chmoda(f, false, false, true);
                break;
            }
            case 5: {
                r = Files._chmoda(f, true, false, true);
                break;
            }
            case 6: {
                r = Files._chmoda(f, false, true, true);
                break;
            }
            case 7: {
                r = Files._chmoda(f, true, true, true);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        switch (v / 10) {
            case 0: {
                return Files._chmodu(f, false, false, false) & r;
            }
            case 1: {
                return Files._chmodu(f, true, false, false) & r;
            }
            case 2: {
                return Files._chmodu(f, false, true, false) & r;
            }
            case 3: {
                return Files._chmodu(f, true, true, false) & r;
            }
            case 4: {
                return Files._chmodu(f, false, false, true) & r;
            }
            case 5: {
                return Files._chmodu(f, true, false, true) & r;
            }
            case 6: {
                return Files._chmodu(f, false, true, true) & r;
            }
            case 7: {
                return Files._chmodu(f, true, true, true) & r;
            }
        }
        throw new IllegalArgumentException();
    }
}

