/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util.io;

import java.io.FileFilter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import net.morilib.util.io.FileAttributeFinderSyntaxException;
import net.morilib.util.io.filter.AndFileFilter;
import net.morilib.util.io.filter.HiddenFileFilter;
import net.morilib.util.io.filter.MtimeFileFilter;
import net.morilib.util.io.filter.NotFileFilter;
import net.morilib.util.io.filter.OrFileFilter;
import net.morilib.util.io.filter.PermissionFileFilter;

public final class FileAttributeFinder {
    static final SimpleDateFormat FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    static final int INIT = 1000;
    static final int STAT_EQ = 1010;
    static final int STAT_LT = 1020;
    static final int STAT_GT = 1030;
    static final int STAT_STR = 1040;
    static final int STAT_NE = 1050;

    static {
        FORMAT.setLenient(false);
    }

    static List<String> lexer(String s) {
        StringBuffer b = new StringBuffer();
        ArrayList<String> r = new ArrayList<String>();
        int stat = 1000;
        int i = 0;
        while (true) {
            int c = i < s.length() ? (int)s.charAt(i++) : -1;
            switch (stat) {
                case 1000: {
                    switch (c) {
                        case -1: {
                            return r;
                        }
                        case 61: {
                            stat = 1010;
                            break;
                        }
                        case 60: {
                            stat = 1020;
                            break;
                        }
                        case 62: {
                            stat = 1030;
                            break;
                        }
                        case 40: {
                            r.add("(");
                            break;
                        }
                        case 41: {
                            r.add(")");
                            break;
                        }
                        case 38: {
                            r.add("&");
                            break;
                        }
                        case 124: {
                            r.add("|");
                            break;
                        }
                        case 33: {
                            stat = 1050;
                            break;
                        }
                        default: {
                            b.append((char)c);
                            stat = 1040;
                            break;
                        }
                    }
                    break;
                }
                case 1010: {
                    switch (c) {
                        case -1: 
                        case 61: {
                            r.add("=");
                            break;
                        }
                        default: {
                            --i;
                            r.add("=");
                        }
                    }
                    stat = 1000;
                    break;
                }
                case 1020: {
                    switch (c) {
                        case -1: {
                            r.add("<");
                            break;
                        }
                        case 61: {
                            r.add("<=");
                            break;
                        }
                        case 62: {
                            r.add("!=");
                            break;
                        }
                        default: {
                            r.add("<");
                            --i;
                        }
                    }
                    stat = 1000;
                    break;
                }
                case 1030: {
                    switch (c) {
                        case -1: {
                            r.add(">");
                            break;
                        }
                        case 61: {
                            r.add(">=");
                            break;
                        }
                        default: {
                            r.add(">");
                            --i;
                        }
                    }
                    stat = 1000;
                    break;
                }
                case 1040: {
                    switch (c) {
                        case -1: {
                            r.add(b.toString());
                            stat = 1000;
                            break;
                        }
                        case 33: 
                        case 38: 
                        case 40: 
                        case 41: 
                        case 60: 
                        case 61: 
                        case 62: 
                        case 124: {
                            --i;
                            r.add(b.toString());
                            b = new StringBuffer();
                            stat = 1000;
                            break;
                        }
                        default: {
                            b.append((char)c);
                            break;
                        }
                    }
                    break;
                }
                case 1050: {
                    switch (c) {
                        case -1: {
                            r.add("!");
                            break;
                        }
                        case 61: {
                            r.add("!=");
                            break;
                        }
                        default: {
                            r.add("!");
                            --i;
                        }
                    }
                    stat = 1000;
                }
            }
        }
    }

    static String nxt(Iterator<String> tok) {
        String s = tok.hasNext() ? tok.next() : null;
        return s;
    }

    static int octalperm(String s) {
        try {
            int r = Integer.parseInt(s, 8);
            return r < 0 || r > 7 ? -1 : r;
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    static FileFilter perm(Iterator<String> tok) {
        String s = FileAttributeFinder.nxt(tok);
        if (s.equals("=")) {
            String t = FileAttributeFinder.nxt(tok);
            int p = FileAttributeFinder.octalperm(t);
            if (p < 0) {
                try {
                    return new PermissionFileFilter(t);
                }
                catch (IllegalArgumentException e) {
                    throw new FileAttributeFinderSyntaxException();
                }
            }
            return new PermissionFileFilter(s, p);
        }
        if (s.equals("<") || s.equals("<=") || s.equals(">") || s.equals(">=") || s.equals("!=")) {
            String t = FileAttributeFinder.nxt(tok);
            int p = FileAttributeFinder.octalperm(t);
            if (p < 0) {
                throw new FileAttributeFinderSyntaxException();
            }
            return new PermissionFileFilter(s, p);
        }
        throw new FileAttributeFinderSyntaxException();
    }

    static FileFilter mtime(Iterator<String> tok) {
        String s = FileAttributeFinder.nxt(tok);
        if (s.equals("=") || s.equals("<") || s.equals("<=") || s.equals(">") || s.equals(">=") || s.equals("!=")) {
            String t = FileAttributeFinder.nxt(tok);
            if (!t.matches("^[0-9][0-9][0-9][0-9]-[0-9][0-9]-[0-9][0-9]$")) {
                throw new FileAttributeFinderSyntaxException(t);
            }
            try {
                Date d = FORMAT.parse(t);
                return new MtimeFileFilter(s, d);
            }
            catch (ParseException e) {
                throw new FileAttributeFinderSyntaxException(e);
            }
        }
        throw new FileAttributeFinderSyntaxException();
    }

    static FileFilter getAnd(List<FileFilter> l) {
        return l.size() == 1 ? l.get(0) : new AndFileFilter(l);
    }

    static FileFilter getOr(List<FileFilter> l) {
        return l.size() == 1 ? l.get(0) : new OrFileFilter(l);
    }

    static boolean isend(String s, String e) {
        return s == null && e == null || s != null && s.equals(e);
    }

    static boolean ismismatch(String s, String e) {
        return s != null && !s.equals(e) || s == null && e != null;
    }

    static FileFilter start2(String s, String e, Iterator<String> tok) {
        ArrayList<FileFilter> l = new ArrayList<FileFilter>();
        FileFilter s1 = FileAttributeFinder.start4(s, e, tok);
        while (true) {
            if (FileAttributeFinder.isend(s = FileAttributeFinder.nxt(tok), e)) {
                l.add(s1);
                return FileAttributeFinder.getOr(l);
            }
            if (s != null && s.equals("&")) {
                Object[] o = FileAttributeFinder.start3(s1, s, e, tok);
                l.add((FileFilter)o[0]);
                s = (String)o[1];
                if (s != null && s.equals("|")) {
                    s = FileAttributeFinder.nxt(tok);
                    s1 = FileAttributeFinder.start4(s, e, tok);
                    continue;
                }
                if (FileAttributeFinder.isend(s, e)) {
                    return FileAttributeFinder.getOr(l);
                }
                if (FileAttributeFinder.ismismatch(s, e)) {
                    throw new FileAttributeFinderSyntaxException(s);
                }
                s1 = FileAttributeFinder.start4(s, e, tok);
                continue;
            }
            if (s == null || !s.equals("|")) break;
            l.add(s1);
            s = FileAttributeFinder.nxt(tok);
            s1 = FileAttributeFinder.start4(s, e, tok);
        }
        throw new FileAttributeFinderSyntaxException(s);
    }

    static Object[] start3(FileFilter s1, String s, String e, Iterator<String> tok) {
        ArrayList<FileFilter> l = new ArrayList<FileFilter>();
        l.add(s1);
        while (true) {
            if (s == null && e == null) {
                Object[] objectArray = new Object[2];
                objectArray[0] = FileAttributeFinder.getAnd(l);
                return objectArray;
            }
            if (s != null && s.equals(e)) {
                return new Object[]{FileAttributeFinder.getAnd(l), s};
            }
            if (s != null && s.equals("|")) {
                return new Object[]{FileAttributeFinder.getAnd(l), s};
            }
            if (s == null || !s.equals("&")) {
                throw new FileAttributeFinderSyntaxException(s);
            }
            l.add(FileAttributeFinder.start4(FileAttributeFinder.nxt(tok), e, tok));
            s = FileAttributeFinder.nxt(tok);
        }
    }

    static FileFilter start4(String s, String e, Iterator<String> tok) {
        if (s == null) {
            throw new FileAttributeFinderSyntaxException("null");
        }
        if (s.equals("(")) {
            return FileAttributeFinder.start2(FileAttributeFinder.nxt(tok), ")", tok);
        }
        if (s.equals("!")) {
            return new NotFileFilter(FileAttributeFinder.start4(FileAttributeFinder.nxt(tok), e, tok));
        }
        if (s.matches("^p(erm(ission)?)?$")) {
            return FileAttributeFinder.perm(tok);
        }
        if (s.matches("^m((odified-)?time)?$")) {
            return FileAttributeFinder.mtime(tok);
        }
        if (s.matches("^h(idden)?$")) {
            return HiddenFileFilter.INSTANCE;
        }
        throw new FileAttributeFinderSyntaxException(s);
    }

    public static FileFilter compile(String s) {
        if (s == null) {
            throw new NullPointerException();
        }
        if (s.equals("")) {
            throw new FileAttributeFinderSyntaxException();
        }
        Iterator<String> tok = FileAttributeFinder.lexer(s.replaceAll("[ \t]+", "")).iterator();
        return FileAttributeFinder.start2(FileAttributeFinder.nxt(tok), null, tok);
    }
}

