/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class StateGraph<T, S> {
    private Map<T, Map<S, T>> graph = new HashMap<T, Map<S, T>>();
    private Map<T, StateIn> stmap = new HashMap<T, StateIn>();

    public static <T, S> StateGraph<T, S> unmodifiableGraph(StateGraph<T, S> w) {
        if (w instanceof Immutable) {
            return w;
        }
        return new Immutable(w);
    }

    private Map<S, T> newNode(T nst) {
        Map<S, T> ne = this.graph.get(nst);
        if (ne == null) {
            ne = new HashMap<S, T>();
            this.graph.put(nst, ne);
            this.stmap.put(nst, new StateIn(nst));
        }
        return ne;
    }

    public void addNode(T nst) {
        this.newNode(nst);
    }

    public void addTrans(T st, S i, T nst) {
        if (st == null || i == null || nst == null) {
            throw new NullPointerException();
        }
        Map<S, T> edges = this.graph.get(st);
        if (edges == null) {
            edges = new HashMap<S, T>();
            edges.put(i, nst);
            this.graph.put(st, edges);
            this.stmap.put(st, new StateIn(st));
        } else {
            edges.put(i, nst);
        }
        this.addNode(nst);
    }

    public State<T> getState(T st) {
        State res = this.stmap.get(st);
        if (res == null) {
            throw new NullPointerException();
        }
        return res;
    }

    public Set<T> getAllNodes() {
        return Collections.unmodifiableSet(this.graph.keySet());
    }

    public Map<S, T> getEdgeMap(T st) {
        return Collections.unmodifiableMap(this.graph.get(st));
    }

    public void addEdgeMap(T st, Map<S, T> edges) {
        Map<S, T> nd = this.newNode(st);
        for (Map.Entry<S, T> e : edges.entrySet()) {
            nd.put(e.getKey(), e.getValue());
        }
    }

    public T get(T st, S inp) {
        Map<S, T> edg = this.graph.get(st);
        if (st == null || inp == null) {
            throw new NullPointerException();
        }
        if (edg == null) {
            throw new IllegalArgumentException();
        }
        T res = edg.get(inp);
        if (res == null) {
            throw new IllegalArgumentException();
        }
        return res;
    }

    public boolean isState(T st) {
        return this.graph.containsKey(st);
    }

    public int stateSize() {
        return this.graph.size();
    }

    private static class Immutable<T, S>
    extends StateGraph<T, S> {
        private StateGraph<T, S> wrapee;

        private Immutable(StateGraph<T, S> w) {
            this.wrapee = w;
        }

        @Override
        public void addNode(T nst) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addTrans(T st, S i, T nst) {
            throw new UnsupportedOperationException();
        }

        @Override
        public T get(T st, S inp) {
            return this.wrapee.get(st, inp);
        }

        @Override
        public Set<T> getAllNodes() {
            return this.wrapee.getAllNodes();
        }

        @Override
        public Map<S, T> getEdgeMap(T st) {
            return this.wrapee.getEdgeMap(st);
        }

        @Override
        public State<T> getState(T st) {
            return this.wrapee.getState(st);
        }

        @Override
        public boolean isState(T st) {
            return this.wrapee.isState(st);
        }

        @Override
        public int stateSize() {
            return this.wrapee.stateSize();
        }

        @Override
        public void addEdgeMap(T st, Map<S, T> edges) {
            throw new UnsupportedOperationException();
        }
    }

    public static interface State<T> {
        public State<T> go(T var1);
    }

    private class StateIn
    implements State<T> {
        private T st;

        private StateIn(T st) {
            this.st = st;
        }

        @Override
        public State<T> go(T alphabet) {
            return (State)StateGraph.this.stmap.get(((Map)StateGraph.this.graph.get(this.st)).get(alphabet));
        }
    }
}

