/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.parser.xml;

import java.io.IOException;
import java.io.InputStream;
import net.morilib.lang.ReflectionException;
import net.morilib.lingua.plural.SimplePluralConverter;
import net.morilib.parser.xml.XMLBeanHelper;
import net.morilib.parser.xml.XMLBeanParseException;
import net.morilib.util.LinkedListStack;
import net.morilib.util.Stack2;
import net.morilib.util.string.StringTransforms;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public abstract class XMLBeanParser {
    private static final int _INIT = 0;
    private static final int _STR1 = 1;
    private static final int _STR2 = 2;
    private static final int _LST1 = 3;
    private static final int _ACPT = 4;
    private static final XMLBeanHelper HELPER = XMLBeanHelper.getInstance();

    protected XMLBeanParser() {
    }

    protected abstract Class<?> forName(String var1) throws ClassNotFoundException;

    public Object parse(InputStream ins) throws SAXException, IOException {
        XMLReader r = XMLReaderFactory.createXMLReader();
        Handler h = new Handler();
        r.setContentHandler(h);
        r.parse(new InputSource(ins));
        return h.result;
    }

    private class Handler
    extends DefaultHandler {
        private StringBuilder buf = null;
        private Stack2<Object> pdstk = new LinkedListStack<Object>();
        private int stat;
        private Object result = null;

        private Handler() {
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.buf == null) {
                this.buf = new StringBuilder();
            }
            this.buf.append(new String(ch, start, length));
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            switch (this.stat) {
                case 0: {
                    if (this.buf != null && !this.buf.toString().trim().isEmpty()) {
                        throw new XMLBeanParseException("extra string appeared between tags");
                    }
                    Object o = this.pdstk.pop();
                    String q = (String)this.pdstk.pop();
                    if (this.pdstk.isEmpty()) {
                        this.stat = 4;
                        this.result = o;
                        break;
                    }
                    HELPER.setField(this.pdstk.peek(), q, o);
                    break;
                }
                case 1: 
                case 2: {
                    String q = (String)this.pdstk.pop();
                    HELPER.setField(this.pdstk.peek(), q, this.buf.toString());
                    this.buf = null;
                    this.stat = 0;
                    break;
                }
                case 4: {
                    throw new IllegalStateException();
                }
            }
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            String q = StringTransforms.HYPHEN_TO_CAMEL.f(qName);
            try {
                switch (this.stat) {
                    case 2: {
                        String s1 = StringTransforms.CAPITALIZE_FIRST.f((String)this.pdstk.peek());
                        Object o1 = HELPER.newInstance(XMLBeanParser.this.forName(s1));
                        this.pdstk.push(o1);
                    }
                    case 0: {
                        this.startElementInit(q, attributes);
                        break;
                    }
                    case 1: {
                        throw new XMLBeanParseException("tag " + this.pdstk.peek() + " cannot be nested");
                    }
                    case 3: {
                        if (!SimplePluralConverter.ENGLISH.isPlural(q, (String)this.pdstk.peek())) {
                            throw new XMLBeanParseException("tag " + q + " is not the plural of" + this.pdstk.peek());
                        }
                        this.pdstk.push(q);
                        break;
                    }
                    case 4: {
                        throw new IllegalStateException();
                    }
                }
            }
            catch (ClassNotFoundException e) {
                throw new ReflectionException(e);
            }
        }

        private void startElementInit(String q, Attributes attributes) throws ClassNotFoundException {
            Object p = this.pdstk.isEmpty() ? null : this.pdstk.peek();
            this.pdstk.push(q);
            if (p != null && attributes.getLength() == 0 && HELPER.isStringField(p, q)) {
                this.stat = 1;
            } else if (p != null && attributes.getLength() == 0 && HELPER.isStringListField(p, q)) {
                this.stat = 2;
            } else if (p != null && attributes.getLength() == 0 && HELPER.isStringListFieldExtra(p, q)) {
                this.stat = 3;
            } else {
                if (this.buf != null && !this.buf.toString().trim().isEmpty()) {
                    throw new XMLBeanParseException("extra string appeared between tags");
                }
                Object o = HELPER.newInstance(XMLBeanParser.this.forName(StringTransforms.CAPITALIZE_FIRST.f(q)));
                int i = 0;
                while (i < attributes.getLength()) {
                    HELPER.setField(o, attributes.getQName(i), attributes.getValue(i));
                    ++i;
                }
                this.pdstk.push(o);
            }
            this.buf = null;
        }
    }
}

