/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.options;

import java.util.Iterator;
import java.util.NoSuchElementException;

class ArgsIterator
implements Iterator<String> {
    private static final String END_OPT = "--";
    private static final String LONG_OPT = "--";
    private String[] args;
    private int pos = 0;

    ArgsIterator(String[] args) {
        this.args = new String[args.length];
        System.arraycopy(args, 0, this.args, 0, args.length);
    }

    @Override
    public boolean hasNext() {
        return this.pos < this.args.length && !this.args[this.pos].equals("--");
    }

    @Override
    public String next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.args[this.pos++];
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    String peek() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.args[this.pos];
    }

    ArgsIterator forward() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.pos;
        return this;
    }

    ArgsIterator forwardShort() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        if (this.args[this.pos].indexOf("--") == 0) {
            ++this.pos;
        } else if (this.args[this.pos].length() > 2) {
            this.args[this.pos] = String.valueOf(this.args[this.pos].substring(0, 1)) + this.args[this.pos].substring(2);
        } else {
            ++this.pos;
        }
        return this;
    }

    boolean isDelim(int optchar) {
        return !this.hasNext() || this.isShortOption(optchar) || this.isLongOption(optchar);
    }

    boolean isShortOption(int optchar) {
        return this.hasNext() && this.args[this.pos].length() > 1 && this.args[this.pos].charAt(0) == optchar && this.args[this.pos].charAt(1) != optchar;
    }

    boolean isLongOption(int optchar) {
        return this.hasNext() && this.args[this.pos].length() > 2 && this.args[this.pos].charAt(0) == optchar && this.args[this.pos].charAt(1) == optchar;
    }

    boolean isOption(int optchar) {
        return this.isShortOption(optchar) || this.isLongOption(optchar);
    }

    String[] operands() {
        if (this.pos < this.args.length && this.args[this.pos].equals("--")) {
            ++this.pos;
        }
        String[] r = new String[this.args.length - this.pos];
        System.arraycopy(this.args, this.pos, r, 0, r.length);
        return r;
    }
}

