/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.net.syslog;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.Date;
import net.morilib.net.syslog.SyslogFacility;
import net.morilib.net.syslog.SyslogHeader;
import net.morilib.net.syslog.SyslogLevel;
import net.morilib.net.syslog.SyslogPRI;

public final class SyslogP {
    private static final int PORT = 514;

    private SyslogP() {
    }

    public static boolean log(InetAddress addr, int port, SyslogLevel level, SyslogFacility facility, Date date, String hostname, String message) throws IOException {
        DatagramSocket sok = new DatagramSocket();
        StringBuilder s = new StringBuilder();
        SyslogPRI pri = new SyslogPRI(facility, level);
        s.append(pri.toSyslogPriority());
        SyslogHeader hdr = new SyslogHeader(date, hostname);
        if (!hdr.isValidHostname()) {
            return false;
        }
        s.append(hdr.toSyslog());
        s.append(' ');
        s.append(message);
        int i = 0;
        while (i < s.length()) {
            if (s.charAt(i) > '\u007f') {
                return false;
            }
            ++i;
        }
        byte[] b = s.toString().getBytes();
        DatagramPacket pkt = new DatagramPacket(b, b.length, addr, port);
        sok.send(pkt);
        return true;
    }

    public static boolean log(InetAddress addr, int port, SyslogLevel level, SyslogFacility facility, String hostname, String message) throws IOException {
        return SyslogP.log(addr, port, level, facility, new Date(), hostname, message);
    }

    public static boolean log(InetAddress addr, SyslogLevel level, SyslogFacility facility, Date date, String hostname, String message) throws IOException {
        return SyslogP.log(addr, 514, level, facility, date, hostname, message);
    }

    public static boolean log(InetAddress addr, SyslogLevel level, SyslogFacility facility, String hostname, String message) throws IOException {
        return SyslogP.log(addr, 514, level, facility, new Date(), hostname, message);
    }

    public static boolean log(String host, int port, SyslogLevel level, SyslogFacility facility, Date date, String hostname, String message) throws IOException {
        return SyslogP.log(InetAddress.getByName(host), port, level, facility, date, hostname, message);
    }

    public static boolean log(String host, int port, SyslogLevel level, SyslogFacility facility, String hostname, String message) throws IOException {
        return SyslogP.log(InetAddress.getByName(host), port, level, facility, new Date(), hostname, message);
    }

    public static boolean log(String host, SyslogLevel level, SyslogFacility facility, Date date, String hostname, String message) throws IOException {
        return SyslogP.log(InetAddress.getByName(host), 514, level, facility, date, hostname, message);
    }

    public static boolean log(String host, SyslogLevel level, SyslogFacility facility, String hostname, String message) throws IOException {
        return SyslogP.log(InetAddress.getByName(host), 514, level, facility, new Date(), hostname, message);
    }
}

