/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.net.snmp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import net.morilib.net.snmp.ASN1;
import net.morilib.net.snmp.ASN1Exception;
import net.morilib.net.snmp.ObjectIdentifier;
import net.morilib.net.snmp.SNMPPDU;
import net.morilib.util.Tuple2;

public final class SNMP {
    private static final byte[] REQ_HEADER_1;
    private static final byte[] REQ_HEADER_2;
    private static final byte GET_REQUEST = -96;
    private static final byte GET_NEXT = -95;

    static {
        byte[] byArray = new byte[3];
        byArray[0] = 2;
        byArray[1] = 1;
        REQ_HEADER_1 = byArray;
        byte[] byArray2 = new byte[9];
        byArray2[0] = 2;
        byArray2[1] = 1;
        byArray2[2] = 72;
        byArray2[3] = 2;
        byArray2[4] = 1;
        byArray2[6] = 2;
        byArray2[7] = 1;
        REQ_HEADER_2 = byArray2;
    }

    static byte[] lengthToBytes(int l) {
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        int c = l;
        if ((c & 0xF0000000) != 0) {
            b.write(c >> 28 | 0x80);
        }
        if ((c & 0xFE00000) != 0) {
            b.write(c >> 21 | 0x80);
        }
        if ((c & 0x1FC000) != 0) {
            b.write(c >> 14 | 0x80);
        }
        if ((c & 0x3F80) != 0) {
            b.write(c >> 7 | 0x80);
        }
        b.write(c & 0x7F);
        return b.toByteArray();
    }

    private static void writeString(ByteArrayOutputStream bos, String s) throws IOException {
        byte[] b = s.getBytes();
        bos.write(4);
        bos.write(SNMP.lengthToBytes(b.length));
        bos.write(b);
    }

    private static void writeOID(ByteArrayOutputStream b2, ObjectIdentifier oid) throws IOException {
        ByteArrayOutputStream b1 = new ByteArrayOutputStream();
        byte[] s = oid.toBytes();
        b1.write(6);
        b1.write(SNMP.lengthToBytes(s.length));
        b1.write(s);
        b1.write(5);
        b1.write(0);
        s = b1.toByteArray();
        b2.write(48);
        b2.write(SNMP.lengthToBytes(s.length));
        b2.write(s);
    }

    private static byte[] createGetRequest(ObjectIdentifier oid) {
        ByteArrayOutputStream b2 = new ByteArrayOutputStream();
        ByteArrayOutputStream b3 = new ByteArrayOutputStream();
        try {
            SNMP.writeOID(b2, oid);
            byte[] s = b2.toByteArray();
            b3.write(REQ_HEADER_2);
            b3.write(48);
            b3.write(SNMP.lengthToBytes(s.length));
            b3.write(s);
            return b3.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] createGetRequestHeader(byte req, String community, ObjectIdentifier oid) {
        ByteArrayOutputStream b1 = new ByteArrayOutputStream();
        ByteArrayOutputStream b2 = new ByteArrayOutputStream();
        try {
            b1.write(REQ_HEADER_1);
            SNMP.writeString(b1, community);
            byte[] s = SNMP.createGetRequest(oid);
            b1.write(req);
            b1.write(SNMP.lengthToBytes(s.length));
            b1.write(s);
            s = b1.toByteArray();
            b2.write(48);
            b2.write(SNMP.lengthToBytes(s.length));
            b2.write(s);
            return b2.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static SNMPPDU toPDU(Object o) throws ASN1Exception {
        SNMPPDU r = new SNMPPDU();
        try {
            List l1 = (List)o;
            r.setVersion(((Number)l1.get(0)).intValue());
            r.setCommunity((String)l1.get(1));
            List l2 = (List)l1.get(2);
            r.setId(((Number)l2.get(0)).intValue());
            r.setErrorCode(((Number)l2.get(1)).intValue());
            r.setErrorIndex(((Number)l2.get(2)).intValue());
            List l3 = (List)l2.get(3);
            ArrayList<Tuple2<ObjectIdentifier, Object>> ll = new ArrayList<Tuple2<ObjectIdentifier, Object>>();
            for (Object p : l3) {
                List l4 = (List)p;
                ll.add(new Tuple2((ObjectIdentifier)l4.get(0), l4.get(1)));
            }
            r.setVariables(ll);
            return r;
        }
        catch (IndexOutOfBoundsException e) {
            throw new ASN1Exception(e);
        }
        catch (ClassCastException e) {
            throw new ASN1Exception(e);
        }
    }

    public static SNMPPDU get(byte req, InetAddress addr, int port, String community, ObjectIdentifier oid) throws IOException, ASN1Exception {
        DatagramSocket sok = null;
        try {
            byte[] s = SNMP.createGetRequestHeader(req, community, oid);
            byte[] t = new byte[8192];
            DatagramPacket pkt = new DatagramPacket(s, s.length, addr, port);
            DatagramPacket lsk = new DatagramPacket(t, t.length);
            sok = new DatagramSocket();
            sok.setSoTimeout(5000);
            sok.send(pkt);
            sok.receive(lsk);
            ByteArrayInputStream bis = new ByteArrayInputStream(lsk.getData());
            DataInputStream din = new DataInputStream(bis);
            SNMPPDU sNMPPDU = SNMP.toPDU(ASN1.read(din));
            return sNMPPDU;
        }
        finally {
            if (sok != null) {
                sok.close();
            }
        }
    }

    public static SNMPPDU getRequest(InetAddress addr, int port, String community, ObjectIdentifier oid) throws IOException, ASN1Exception {
        return SNMP.get((byte)-96, addr, port, community, oid);
    }

    public static SNMPPDU getRequest(String host, int port, String community, ObjectIdentifier oid) throws IOException, ASN1Exception {
        return SNMP.getRequest(InetAddress.getByName(host), port, community, oid);
    }

    public static SNMPPDU getRequest(InetAddress addr, String community, ObjectIdentifier oid) throws IOException, ASN1Exception {
        return SNMP.getRequest(addr, 161, community, oid);
    }

    public static SNMPPDU getRequest(String host, String community, ObjectIdentifier oid) throws IOException, ASN1Exception {
        return SNMP.getRequest(InetAddress.getByName(host), 161, community, oid);
    }

    public static SNMPPDU getNext(InetAddress addr, int port, String community, ObjectIdentifier oid) throws IOException, ASN1Exception {
        return SNMP.get((byte)-95, addr, port, community, oid);
    }

    public static SNMPPDU getNext(String host, int port, String community, ObjectIdentifier oid) throws IOException, ASN1Exception {
        return SNMP.getNext(InetAddress.getByName(host), port, community, oid);
    }

    public static SNMPPDU getNext(InetAddress addr, String community, ObjectIdentifier oid) throws IOException, ASN1Exception {
        return SNMP.getNext(addr, 161, community, oid);
    }

    public static SNMPPDU getNext(String host, String community, ObjectIdentifier oid) throws IOException, ASN1Exception {
        return SNMP.getNext(InetAddress.getByName(host), 161, community, oid);
    }
}

