/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.net.routing;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import net.morilib.net.routing.RIPRouteInfo;

public final class RIP {
    static final int DEFAULT_PORT = 520;
    static final int TIMEOUT = 5000;
    static final byte REQUEST = 1;
    static final byte RESPONSE = 2;
    static final short ADDRESS_FAMILY_INETV4 = 2;

    private RIP() {
    }

    private static InetAddress getByAddress(byte[] b) throws UnknownHostException {
        if (b[0] == 0 && b[1] == 0 && b[2] == 0 && b[3] == 0) {
            return null;
        }
        return InetAddress.getByAddress(b);
    }

    static RIPRouteInfo parseInfo(DataInputStream dis) {
        RIPRouteInfo r = new RIPRouteInfo();
        byte[] b = new byte[4];
        try {
            try {
                r.addressIdentifier = dis.readShort();
            }
            catch (EOFException e) {
                return null;
            }
        }
        catch (IOException e) {
            throw new RuntimeException();
        }
        r.routeTag = dis.readShort();
        dis.read(b);
        r.address = RIP.getByAddress(b);
        dis.read(b);
        r.mask = RIP.getByAddress(b);
        r.nextHop = dis.readInt();
        r.metric = dis.readInt();
        if (r.metric > 15) {
            r.metric = -1;
        }
        return r;
    }

    static RIPRouteInfo[] parsePacket(byte[] b) {
        ArrayList<RIPRouteInfo> res;
        DataInputStream dis;
        block4: {
            ByteArrayInputStream bis = new ByteArrayInputStream(b);
            dis = new DataInputStream(bis);
            res = new ArrayList<RIPRouteInfo>();
            if (dis.readByte() == 2) break block4;
            return null;
        }
        try {
            RIPRouteInfo r0;
            dis.readByte();
            dis.readShort();
            while ((r0 = RIP.parseInfo(dis)) != null) {
                if (r0.metric == 0) continue;
                res.add(r0);
            }
            return res.toArray(new RIPRouteInfo[0]);
        }
        catch (IOException e) {
            throw new RuntimeException();
        }
    }

    public static RIPRouteInfo[] request(InetAddress address, int version, InetAddress ... route) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        if (version < 1 || version > 2) {
            throw new IllegalArgumentException();
        }
        if (address.getAddress().length != 4) {
            throw new IllegalArgumentException();
        }
        if (route.length >= 25) {
            throw new IllegalArgumentException();
        }
        try {
            dos.writeByte(1);
            dos.writeByte(version);
            dos.writeShort(0);
            InetAddress[] inetAddressArray = route;
            int n = route.length;
            int n2 = 0;
            while (n2 < n) {
                InetAddress r = inetAddressArray[n2];
                dos.writeShort(2);
                dos.writeShort(0);
                dos.write(r.getAddress());
                dos.writeInt(0);
                dos.writeInt(0);
                dos.writeInt(0);
                ++n2;
            }
        }
        catch (IOException e) {
            throw new RuntimeException();
        }
        DatagramSocket sok = new DatagramSocket();
        sok.setSoTimeout(5000);
        byte[] b = bos.toByteArray();
        DatagramPacket pkt = new DatagramPacket(b, b.length, address, 520);
        byte[] d = new byte[504];
        DatagramPacket pkr = new DatagramPacket(d, d.length);
        sok.send(pkt);
        sok.receive(pkr);
        return RIP.parsePacket(pkr.getData());
    }
}

