/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.net.ntp;

public enum NTPMode {
    RESERVED(0),
    SYMMETRIC_ACTIVE(1),
    SYMMETRIC_PASSIVE(2),
    CLIANT(3),
    SERVER(4),
    BROADCAST(5),
    NTP_MESSAGE(6),
    PRIVATE(7);

    private int cd;

    private NTPMode(int cd) {
        this.cd = cd;
    }

    public static NTPMode getFromNTPBits(int bt) {
        switch (bt & 7) {
            case 0: {
                return RESERVED;
            }
            case 1: {
                return SYMMETRIC_ACTIVE;
            }
            case 2: {
                return SYMMETRIC_PASSIVE;
            }
            case 3: {
                return CLIANT;
            }
            case 4: {
                return SERVER;
            }
            case 5: {
                return BROADCAST;
            }
            case 6: {
                return NTP_MESSAGE;
            }
            case 7: {
                return PRIVATE;
            }
        }
        throw new IllegalArgumentException();
    }

    public int getCode() {
        return this.cd;
    }
}

