/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.net.misc;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;

public class Echo {
    private static final String HELLO_STR = "\"HELLO!!\"\n";
    private static final String HELLO_STR2 = "\"HELLO!!\"\n";
    private static final int DEFAULT_TIMEOUT = 2000;
    private static final int BUFSIZE = 4096;
    public static final int DEFAULT_PORT = 7;

    public static String sendByTCP(InetAddress addr, int port, int timeout, String s) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        Socket sok = null;
        InputStream ins = null;
        OutputStream ous = null;
        byte[] bf2 = new byte[4096];
        try {
            sok = new Socket(addr, port);
            sok.setSoTimeout(timeout);
            ous = sok.getOutputStream();
            byte[] buf = s.getBytes();
            if (buf.length >= 4096) {
                throw new IllegalArgumentException();
            }
            ous.write(buf);
            ins = sok.getInputStream();
            int l = ins.read(bf2);
            bos.write(bf2, 0, l);
            String string = new String(bos.toByteArray());
            return string;
        }
        finally {
            if (ins != null) {
                ins.close();
            }
            if (ous != null) {
                ous.close();
            }
            if (sok != null) {
                sok.close();
            }
        }
    }

    public static String sendByTCP(String host, int port, int timeout, String s) throws IOException {
        return Echo.sendByTCP(InetAddress.getByName(host), port, timeout, s);
    }

    public static String sendByTCP(InetAddress addr, int port, String s) throws IOException {
        return Echo.sendByTCP(addr, port, 2000, s);
    }

    public static String sendByTCP(String host, int port, String s) throws IOException {
        return Echo.sendByTCP(InetAddress.getByName(host), port, 2000, s);
    }

    public static String sendByUDP(InetAddress addr, int port, int timeout, String s) throws IOException {
        byte[] b = new byte[4096];
        byte[] a = s.getBytes();
        if (a.length >= 4096) {
            throw new IllegalArgumentException();
        }
        DatagramSocket sok = new DatagramSocket();
        sok.setSoTimeout(timeout);
        DatagramPacket spk = new DatagramPacket(a, a.length, addr, port);
        sok.send(spk);
        DatagramPacket rpk = new DatagramPacket(b, b.length);
        sok.receive(rpk);
        return new String(b, 0, rpk.getLength());
    }

    public static String sendByUDP(String host, int port, int timeout, String s) throws IOException {
        return Echo.sendByUDP(InetAddress.getByName(host), port, timeout, s);
    }

    public static String sendByUDP(InetAddress addr, int port, String s) throws IOException {
        return Echo.sendByUDP(addr, port, 2000, s);
    }

    public static String sendByUDP(String host, int port, String s) throws IOException {
        return Echo.sendByUDP(InetAddress.getByName(host), port, 2000, s);
    }

    public static boolean helloTCP(InetAddress addr, int port, int timeout) {
        try {
            String s = Echo.sendByTCP(addr, port, "\"HELLO!!\"\n");
            return s.equals("\"HELLO!!\"\n") || s.equals("\"HELLO!!\"\n");
        }
        catch (IOException e) {
            return false;
        }
    }

    public static boolean helloTCP(String host, int port, int timeout) {
        try {
            return Echo.helloTCP(InetAddress.getByName(host), port, timeout);
        }
        catch (UnknownHostException e) {
            return false;
        }
    }

    public static boolean helloUDP(InetAddress addr, int port, int timeout) {
        try {
            String s = Echo.sendByUDP(addr, port, "\"HELLO!!\"\n");
            return s.equals("\"HELLO!!\"\n");
        }
        catch (IOException e) {
            return false;
        }
    }

    public static boolean helloUDP(String host, int port, int timeout) {
        try {
            return Echo.helloUDP(InetAddress.getByName(host), port, timeout);
        }
        catch (UnknownHostException e) {
            return false;
        }
    }
}

