/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.net.dhcp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import net.morilib.net.dhcp.BOOTPResult;

public final class BOOTP {
    static final byte BOOTREQUEST = 1;
    static final byte BOOTREPLY = 2;
    static final byte ETHERNET_10MB = 1;
    static final byte HARDWARE_ADDRESS_LENGTH = 6;
    static final int BOOTP_SERVER_PORT = 67;
    static final int BOOTP_CLIENT_PORT = 68;
    static final int BUFFER_SIZE = 300;
    static final int TIMEOUT = 4000;

    private static void fill(DataOutputStream dos, int bytes, byte fill) throws IOException {
        int i = 0;
        while (i < bytes) {
            dos.writeByte(fill);
            ++i;
        }
    }

    static ByteArrayOutputStream createCommonFormat(byte[] hwaddr, InetAddress ciaddr, short secs, int[] xid) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        xid[0] = (int)(Math.random() * 2.147483647E9);
        if (hwaddr.length != 6) {
            throw new IllegalArgumentException();
        }
        if (ciaddr != null && ciaddr.getAddress().length != 4) {
            throw new IllegalArgumentException();
        }
        try {
            dos.writeByte(1);
            dos.writeByte(1);
            dos.writeByte(6);
            dos.writeByte(0);
            dos.writeInt(xid[0]);
            dos.writeShort(secs);
            dos.writeShort(0);
            if (ciaddr == null) {
                dos.writeInt(0);
            } else {
                dos.write(ciaddr.getAddress());
            }
            dos.writeInt(0);
            dos.writeInt(0);
            dos.writeInt(0);
            dos.write(hwaddr);
            BOOTP.fill(dos, 64, (byte)0);
            BOOTP.fill(dos, 128, (byte)0);
            return bos;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static byte[] createBroadcastFormat(byte[] hwaddr, InetAddress ciaddr, short secs, int[] xid) {
        ByteArrayOutputStream bos = BOOTP.createCommonFormat(hwaddr, ciaddr, secs, xid);
        DataOutputStream dos = new DataOutputStream(bos);
        try {
            BOOTP.fill(dos, 64, (byte)0);
            return bos.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static BOOTPResult parseCommonFormat(byte[] format, int xid, ByteArrayInputStream[] bis0) {
        int sip;
        int yip;
        byte[] ip;
        byte[] str;
        StringBuffer b;
        BOOTPResult r;
        ByteArrayInputStream bis;
        block12: {
            DataInputStream dis;
            block11: {
                block10: {
                    block9: {
                        bis = new ByteArrayInputStream(format);
                        dis = new DataInputStream(bis);
                        r = new BOOTPResult();
                        b = new StringBuffer();
                        str = new byte[128];
                        ip = new byte[4];
                        if (dis.readByte() == 2) break block9;
                        return null;
                    }
                    dis.readByte();
                    dis.readByte();
                    dis.readByte();
                    if (dis.readInt() == xid) break block10;
                    return null;
                }
                dis.readShort();
                dis.readShort();
                dis.readInt();
                yip = dis.readInt();
                sip = dis.readInt();
                dis.readInt();
                dis.readLong();
                dis.readLong();
                if (dis.read(str, 0, 64) == 64) break block11;
                return null;
            }
            if (dis.read(str, 0, 128) == 128) break block12;
            return null;
        }
        try {
            int i = 0;
            while (i < str.length) {
                if (str[i] == 0) break;
                b.append((char)str[i]);
                ++i;
            }
            r.bootFilePath = b.toString();
            ip[0] = (byte)(yip >> 24 & 0xFF);
            ip[1] = (byte)(yip >> 24 & 0xFF);
            ip[2] = (byte)(yip >> 24 & 0xFF);
            ip[3] = (byte)(yip >> 24 & 0xFF);
            r.myAddress = InetAddress.getByAddress(ip);
            ip[0] = (byte)(sip >> 24 & 0xFF);
            ip[1] = (byte)(sip >> 24 & 0xFF);
            ip[2] = (byte)(sip >> 24 & 0xFF);
            ip[3] = (byte)(sip >> 24 & 0xFF);
            r.serverAddress = InetAddress.getByAddress(ip);
            if (bis0 != null) {
                bis0[0] = bis;
            }
            return r;
        }
        catch (EOFException e) {
            return null;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static BOOTPResult request(InetAddress ipaddr, InetAddress ciaddr, byte[] hwaddr, short secs) throws IOException {
        DatagramSocket svs = null;
        DatagramSocket cls = null;
        byte[] bur = new byte[300];
        int[] xid = new int[1];
        try {
            InetAddress brd = ipaddr;
            svs = new DatagramSocket();
            cls = new DatagramSocket(68);
            svs.connect(brd, 67);
            byte[] buf = BOOTP.createBroadcastFormat(hwaddr, ciaddr, secs, xid);
            DatagramPacket svp = new DatagramPacket(buf, buf.length, brd, 67);
            svs.setBroadcast(true);
            cls.setBroadcast(true);
            DatagramPacket clp = new DatagramPacket(bur, bur.length);
            cls.setSoTimeout(4000);
            svs.send(svp);
            cls.receive(clp);
            BOOTPResult bOOTPResult = BOOTP.parseCommonFormat(clp.getData(), xid[0], null);
            return bOOTPResult;
        }
        finally {
            if (svs != null) {
                svs.close();
            }
            if (cls != null) {
                cls.close();
            }
        }
    }
}

