/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.math.stat.dist.continuous;

import net.morilib.math.special.Erf;
import net.morilib.math.stat.DistributionUtils;
import net.morilib.math.stat.dist.AbstractContinuousDistribution;

public class NormalDistribution
extends AbstractContinuousDistribution {
    private double mean;
    private double variance;

    public NormalDistribution(double mean, double variance) {
        if (variance <= 0.0) {
            throw new IllegalArgumentException();
        }
        this.mean = mean;
        this.variance = variance;
    }

    @Override
    public double expectedValue() {
        return this.mean;
    }

    @Override
    public double variance() {
        return this.variance;
    }

    @Override
    public double mode() {
        return this.mean;
    }

    @Override
    public double skewness() {
        return 0.0;
    }

    @Override
    public double kurtosis() {
        return 0.0;
    }

    @Override
    public double f(double x) {
        double k = -((x - this.mean) * (x - this.mean) / 2.0 / this.variance);
        double a = 1.0 / Math.sqrt(Math.PI * 2 * this.variance);
        return a * Math.exp(k);
    }

    @Override
    public boolean isInSupport(double n) {
        return true;
    }

    @Override
    public double cdf(double x) {
        return DistributionUtils.trimCdf(0.5 * (1.0 + Erf.erf((x - this.mean) / Math.sqrt(2.0 * this.variance))), 1.0E-13);
    }

    @Override
    public double supportSupremum() {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public double supportInfimum() {
        return Double.NEGATIVE_INFINITY;
    }

    public int hashCode() {
        int r = 17;
        r = 37 * (r + (int)Double.doubleToLongBits(this.mean));
        r = 37 * (r + (int)Double.doubleToLongBits(this.variance));
        return r;
    }

    public boolean equals(Object o) {
        if (o instanceof NormalDistribution) {
            NormalDistribution n = (NormalDistribution)o;
            return this.mean == n.mean && this.variance == n.variance;
        }
        return false;
    }

    @Override
    public double median() {
        return this.mean;
    }
}

