/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.math.stat.dist.continuous;

import net.morilib.math.stat.dist.AbstractContinuousDistribution;

public class ContinuousUniformDistribution
extends AbstractContinuousDistribution {
    private double a;
    private double b;

    public ContinuousUniformDistribution(double a, double b) {
        if (a >= b) {
            throw new IllegalArgumentException();
        }
        this.a = a;
        this.b = b;
    }

    public double getA() {
        return this.a;
    }

    public double getB() {
        return this.b;
    }

    @Override
    public double expectedValue() {
        return (this.a + this.b) / 2.0;
    }

    @Override
    public double variance() {
        return (this.b - this.a) * (this.b - this.a) / 12.0;
    }

    @Override
    public double mode() {
        return (this.a + this.b) / 2.0;
    }

    @Override
    public double skewness() {
        return 0.0;
    }

    @Override
    public double kurtosis() {
        return -1.2;
    }

    @Override
    public double f(double x) {
        return this.a <= x && x <= this.b ? 1.0 / (this.b - this.a) : 0.0;
    }

    @Override
    public boolean isInSupport(double n) {
        return true;
    }

    @Override
    public double cdf(double x) {
        if (x < this.a) {
            return 0.0;
        }
        if (x < this.b) {
            return (x - this.a) / (this.b - this.a);
        }
        return 1.0;
    }

    @Override
    public double supportSupremum() {
        return this.b;
    }

    @Override
    public double supportInfimum() {
        return this.a;
    }

    @Override
    public double invCdf(double p) {
        if (p < this.a) {
            return 0.0;
        }
        if (p < this.b) {
            return p * (this.b - this.a) + this.a;
        }
        return 1.0;
    }

    @Override
    public double median() {
        return (this.a + this.b) / 2.0;
    }

    public int hashCode() {
        int r = 17;
        r = 37 * (r + (int)Double.doubleToLongBits(this.a));
        r = 37 * (r + (int)Double.doubleToLongBits(this.b));
        return r;
    }

    public boolean equals(Object o) {
        if (o instanceof ContinuousUniformDistribution) {
            ContinuousUniformDistribution n = (ContinuousUniformDistribution)o;
            return this.a == n.a && this.b == n.b;
        }
        return false;
    }
}

