/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.math.series;

import net.morilib.lang.number.Rational;
import net.morilib.math.series.ContinuedFractionSeries;

public class ExpFractionSeries
extends ContinuedFractionSeries {
    private static final Rational TWO = Rational.valueOf(2);
    private Rational z;

    public ExpFractionSeries(Rational z) {
        this.z = z;
        this.init();
        this.next();
    }

    @Override
    protected Rational getA1() {
        return TWO.multiply(this.z);
    }

    @Override
    protected Rational getAn(int n) {
        return this.z.multiply(this.z);
    }

    @Override
    protected Rational getB0() {
        return Rational.ONE;
    }

    @Override
    protected Rational getB1() {
        return Rational.ONE.subtract(this.z);
    }

    @Override
    protected Rational getBn(int n) {
        return Rational.valueOf(2 * n + 1);
    }
}

