/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.math.polynomial1;

import java.util.Arrays;

public class DoublePolynomial1 {
    public static final DoublePolynomial1 ZERO = new DoublePolynomial1(0.0);
    double[] coefficients;

    public DoublePolynomial1(double ... ds) {
        int d = this.degree(ds);
        this.coefficients = new double[d + 1];
        int i = 0;
        while (i <= d) {
            this.coefficients[i] = ds[i];
            ++i;
        }
    }

    private int degree(double[] coeff) {
        int i = coeff.length - 1;
        while (i >= 0) {
            if (coeff[i] != 0.0) {
                return i;
            }
            --i;
        }
        return -1;
    }

    public double coefficient(int n) {
        if (n < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n >= this.coefficients.length) {
            return 0.0;
        }
        return this.coefficients[n];
    }

    public int degree() {
        return this.coefficients.length - 1;
    }

    public boolean isZero() {
        return this.coefficients.length == 0 || this.coefficients.length == 1 && this.coefficients[0] == 0.0;
    }

    public DoublePolynomial1 uminus() {
        DoublePolynomial1 r = new DoublePolynomial1(this.coefficients);
        int i = 0;
        while (i <= r.degree()) {
            r.coefficients[i] = -r.coefficients[i];
            ++i;
        }
        return r;
    }

    public double substitute(double x) {
        double r = 0.0;
        int i = this.degree();
        while (i >= 0) {
            r = r * x + this.coefficients[i];
            --i;
        }
        return r;
    }

    public DoublePolynomial1 div(double a) {
        DoublePolynomial1 r = new DoublePolynomial1(this.coefficients);
        int i = 0;
        while (i <= r.degree()) {
            r.coefficients[i] = r.coefficients[i] / a;
            ++i;
        }
        return r;
    }

    public DoublePolynomial1[] divAndRemainder(DoublePolynomial1 b) {
        if (this.degree() < b.degree()) {
            return new DoublePolynomial1[]{ZERO, this};
        }
        if (b.degree() == 0) {
            return new DoublePolynomial1[]{this.div(b.coefficient(0)), ZERO};
        }
        double[] d = new double[this.degree() - b.degree() + 1];
        double[] r = new double[this.degree() + 1];
        System.arraycopy(this.coefficients, 0, r, 0, r.length);
        int i = this.degree() - b.degree();
        while (i >= 0) {
            double x = r[i + b.degree()] / b.coefficient(b.degree());
            int j = i + b.degree();
            while (j >= i) {
                r[j] = r[j] - b.coefficient(j - i) * x;
                --j;
            }
            d[i] = x;
            --i;
        }
        return new DoublePolynomial1[]{new DoublePolynomial1(d), new DoublePolynomial1(r)};
    }

    public DoublePolynomial1 differenciate() {
        if (this.coefficients.length > 0) {
            double[] r = new double[this.degree()];
            int i = 1;
            while (i <= r.length) {
                r[i - 1] = this.coefficients[i] * (double)i;
                ++i;
            }
            return new DoublePolynomial1(r);
        }
        return ZERO;
    }

    public DoublePolynomial1 multiply(DoublePolynomial1 b) {
        double[] r = new double[this.degree() + b.degree() + 1];
        Arrays.fill(r, 0.0);
        int i = 0;
        while (i <= this.degree()) {
            int j = 0;
            while (j <= b.degree()) {
                r[i + j] = r[i + j] + this.coefficient(i) * b.coefficient(j);
                ++j;
            }
            ++i;
        }
        return new DoublePolynomial1(r);
    }

    public String toString() {
        return Arrays.toString(this.coefficients);
    }
}

