/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.math.constants;

import java.math.BigInteger;
import java.util.Iterator;
import java.util.Locale;
import net.morilib.lang.number.Rational;
import net.morilib.math.constants.AlternatingSeriesNumber;
import net.morilib.math.series.SqrtSeries;
import net.morilib.math.series.decimal.ConstantSeries;
import net.morilib.math.series.decimal.RationalDecimalSeries;

public class SqrtNumber
extends AlternatingSeriesNumber {
    private Rational val;

    public SqrtNumber(Rational x, Rational scale, Rational shift) {
        super(SqrtNumber._iter(x), scale, shift);
        this.val = x;
    }

    private static Iterable<Rational> _iter(Rational x) {
        BigInteger d;
        final BigInteger n = x.getNumerator().toBigInteger();
        final BigInteger[] r = n.divideAndRemainder(d = x.getDenominator().toBigInteger());
        if (r[1].equals(BigInteger.ZERO)) {
            return new Iterable<Rational>(){

                @Override
                public Iterator<Rational> iterator() {
                    return new SqrtSeries(new ConstantSeries(r[0]));
                }
            };
        }
        return new Iterable<Rational>(){

            @Override
            public Iterator<Rational> iterator() {
                return new SqrtSeries(new RationalDecimalSeries(n, d));
            }
        };
    }

    public String toString() {
        String sh;
        String en;
        String st;
        if (Locale.getDefault().getLanguage().equals("ja")) {
            st = "\u221a";
            en = "";
        } else {
            st = "sqrt(";
            en = ")";
        }
        String string = this.shift.isZero() ? "" : (sh = this.shift.signum() > 0 ? "+" + this.shift : "" + this.shift);
        if (this.scale.isUnit()) {
            return String.valueOf(st) + this.val + en + sh;
        }
        return this.scale + st + this.val + en + sh;
    }
}

