/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.math.constants;

import java.util.Iterator;
import net.morilib.lang.number.Rational;
import net.morilib.math.constants.AlternatingSeriesNumber;
import net.morilib.math.series.Exp2FractionSeries;
import net.morilib.math.series.ExpFractionSeries;

public class ExpNumber
extends AlternatingSeriesNumber {
    private static final Rational TWO = Rational.valueOf(2);
    private static final Iterable<Rational> EXP2 = new Iterable<Rational>(){

        @Override
        public Iterator<Rational> iterator() {
            return new Exp2FractionSeries();
        }
    };
    private Rational val;

    public ExpNumber(Rational x, Rational scale, Rational shift) {
        super(ExpNumber._iter(x), scale, shift);
        this.val = x;
    }

    private static Iterable<Rational> _iter(Rational x) {
        final Rational x0 = x.divide(TWO);
        if (x.equals(TWO)) {
            return EXP2;
        }
        return new Iterable<Rational>(){

            @Override
            public Iterator<Rational> iterator() {
                return new ExpFractionSeries(x0);
            }
        };
    }

    public String toString() {
        String ss;
        String string = ss = this.val.isUnit() ? "e" : "e^" + this.val;
        String sh = this.shift.isZero() ? "" : (this.shift.signum() > 0 ? "+" + this.shift : "" + this.shift);
        return this.scale.isUnit() ? String.valueOf(ss) + sh : this.scale + ss + sh;
    }
}

