/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.math.analysis.inexact;

import net.morilib.lang.transform.DoubleTransform;

public final class MonotonicFunctions {
    private static final double MAX_SOLUTION = 1.0E140;
    private static final double MIN_SOLUTION = -1.0E140;

    private MonotonicFunctions() {
    }

    public static double findRootByBisectionMethod(DoubleTransform f, double x, double a, double b) {
        double p = a > Double.NEGATIVE_INFINITY ? a : -1.0E140;
        double q = b < Double.POSITIVE_INFINITY ? b : 1.0E140;
        double ya = f.f(p) - x;
        double yb = f.f(q) - x;
        if (ya == 0.0) {
            return p;
        }
        if (yb == 0.0) {
            return q;
        }
        if (Math.signum(ya) * Math.signum(yb) > 0.0) {
            return Double.NaN;
        }
        q = (p + q) / 2.0;
        while (Math.abs(p - q) > Math.max(Math.ulp(p), Math.ulp(q))) {
            ya = f.f(p) - x;
            yb = f.f(q) - x;
            if (Double.isNaN(ya)) {
                ya = -1.7976931348623157E308;
            }
            if (Double.isNaN(yb)) {
                yb = Double.MAX_VALUE;
            }
            if (ya == 0.0) {
                return p;
            }
            if (yb == 0.0) {
                return q;
            }
            if (Math.signum(ya) * Math.signum(yb) > 0.0) {
                double t = p;
                p = q;
                q += q - t;
                continue;
            }
            q = (p + q) / 2.0;
        }
        return p;
    }
}

