/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.uvector;

import java.io.Serializable;
import java.util.List;
import net.morilib.lisp.Atom;
import net.morilib.lisp.Cons;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.ConsListBuilder;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispBoolean;
import net.morilib.lisp.LispInteger;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispReal;
import net.morilib.lisp.LispString;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.Nil;
import net.morilib.lisp.Subr;
import net.morilib.lisp.subr.BinaryArgs;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.lisp.subr.UnaryArgs;
import net.morilib.lisp.uvector.HomogeneousUnsignedArray;
import net.morilib.util.Bytes;
import net.morilib.util.primitive.IntegerArrayVector;
import net.morilib.util.uvector.IntArray;

public class LispU32Vector
extends Atom
implements HomogeneousUnsignedArray,
Serializable {
    private IntArray vector;

    private LispU32Vector() {
    }

    public LispU32Vector(int ... bs) {
        this.vector = IntArray.newArray(bs);
    }

    public static LispU32Vector malloc(int size) {
        LispU32Vector res = new LispU32Vector();
        res.vector = IntArray.malloc(size);
        return res;
    }

    private static boolean checkRange(Datum d) {
        if (!(d instanceof LispReal)) {
            return false;
        }
        return ((LispReal)d).inUnsignedIntRange();
    }

    private static int[] toIntList(Datum body, LispMessage mesg) {
        ConsIterator itr = new ConsIterator(body);
        IntegerArrayVector v = new IntegerArrayVector();
        while (itr.hasNext()) {
            Datum d = itr.next();
            if (!LispU32Vector.checkRange(d)) {
                throw mesg.getError("err.uvector.outofrange.u32", d);
            }
            v.add((int)d.getLong());
        }
        if (!itr.getTerminal().equals(Nil.NIL)) {
            throw mesg.getError("err.list", body);
        }
        return v.toIntArray();
    }

    @Override
    public String print() {
        StringBuilder b = new StringBuilder();
        String d = "";
        b.append("#u32(");
        int i = 0;
        while (i < this.vector.size()) {
            b.append(d);
            b.append(Bytes.uintToLong(this.vector.getInt(i)));
            d = " ";
            ++i;
        }
        b.append(")");
        return b.toString();
    }

    @Override
    public String getResult() {
        return this.print();
    }

    @Override
    public LispString toLispString() {
        return new LispString(this.print());
    }

    @Override
    public boolean equalsArray(Datum d1, Datum d2) {
        if (!(d1 instanceof LispU32Vector)) {
            return false;
        }
        if (!(d2 instanceof LispU32Vector)) {
            return false;
        }
        return ((LispU32Vector)d1).vector.equals(((LispU32Vector)d2).vector);
    }

    @Override
    public LispReal get(int index) {
        return LispInteger.valueOf(Bytes.uintToLong(this.vector.getInt(index)));
    }

    @Override
    public void set(int index, LispReal x) {
        this.vector.setInt(index, (int)x.getLong());
    }

    @Override
    public int size() {
        return this.vector.size();
    }

    @Override
    public void checkRange(LispReal x, LispMessage mesg) {
        if (!LispU32Vector.checkRange(x)) {
            throw mesg.getError("err.uvector.outofrange.u32", x);
        }
    }

    @Override
    public void set(int index, int x) {
        this.vector.setInt(index, x);
    }

    @Override
    public void set(int index, long x) {
        this.vector.setLong(index, x);
    }

    @Override
    public void set(int index, double x) {
        this.vector.setDouble(index, x);
    }

    @Override
    public Datum ref(Datum arg, LispMessage mesg) {
        int k = SubrUtils.getSmallInt(arg, mesg);
        if (k < 0 || k >= this.size()) {
            throw mesg.getError("err.accessor.ref.outofrange", arg);
        }
        return this.get(k);
    }

    public static class EqualU32Vector
    extends BinaryArgs {
        @Override
        protected Datum execute(Datum c1a, Datum c2a, Environment env, LispMessage mesg) {
            if (!(c1a instanceof LispU32Vector)) {
                throw mesg.getError("err.uvector.require.u32", c1a);
            }
            if (!(c2a instanceof LispU32Vector)) {
                throw mesg.getError("err.uvector.require.u32", c2a);
            }
            return LispBoolean.getInstance(((LispU32Vector)c1a).vector.equals(((LispU32Vector)c2a).vector));
        }
    }

    public static class IsU32Vector
    extends UnaryArgs {
        @Override
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            return LispBoolean.getInstance(c1a instanceof LispU32Vector);
        }
    }

    public static class ListToU32Vector
    extends UnaryArgs {
        @Override
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            if (c1a instanceof Cons || c1a.equals(Nil.NIL)) {
                return new LispU32Vector(LispU32Vector.toIntList(c1a, mesg));
            }
            throw mesg.getError("err.require.list", c1a);
        }
    }

    public static class MakeU32Vector
    extends Subr {
        private int[] makeVector(int len, long d) {
            IntegerArrayVector b = new IntegerArrayVector();
            int i = 0;
            while (i < len) {
                b.add((int)d);
                ++i;
            }
            return b.toIntArray();
        }

        @Override
        public Datum eval(Datum body, Environment env, LispMessage mesg) {
            List<Datum> lst = LispUtils.consToList(body, mesg);
            if (lst.size() == 1) {
                int t = SubrUtils.getSmallInt(lst.get(0), mesg);
                if (t < 0) {
                    throw mesg.getError("err.require.int.nonnegative", lst.get(0));
                }
                return new LispU32Vector(this.makeVector(t, 0L));
            }
            if (lst.size() == 2) {
                int t = SubrUtils.getSmallInt(lst.get(0), mesg);
                if (t < 0) {
                    throw mesg.getError("err.require.int.nonnegative", lst.get(0));
                }
                if (!LispU32Vector.checkRange(lst.get(1))) {
                    throw mesg.getError("err.uvector.outofrange.u32", lst.get(1));
                }
                return new LispU32Vector(this.makeVector(t, lst.get(1).getLong()));
            }
            throw mesg.getError("err.argument", this.symbolName);
        }
    }

    public static class U32Vector
    extends Subr {
        @Override
        public Datum eval(Datum body, Environment env, LispMessage mesg) {
            return new LispU32Vector(LispU32Vector.toIntList(body, mesg));
        }
    }

    public static class U32VectorToList
    extends UnaryArgs {
        @Override
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            if (c1a instanceof LispU32Vector) {
                ConsListBuilder b = new ConsListBuilder();
                LispU32Vector v = (LispU32Vector)c1a;
                int i = 0;
                while (i < v.vector.size()) {
                    b.append(LispInteger.valueOf(Bytes.uintToLong(v.vector.getInt(i))));
                    ++i;
                }
                return b.get();
            }
            throw mesg.getError("err.uvector.outofrange.u32", c1a);
        }
    }
}

