/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.uvector;

import java.io.Serializable;
import java.util.List;
import net.morilib.lisp.Atom;
import net.morilib.lisp.Cons;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.ConsListBuilder;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispBoolean;
import net.morilib.lisp.LispInteger;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispReal;
import net.morilib.lisp.LispString;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.Nil;
import net.morilib.lisp.Subr;
import net.morilib.lisp.subr.BinaryArgs;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.lisp.subr.UnaryArgs;
import net.morilib.lisp.uvector.HomogeneousSignedArray;
import net.morilib.lisp.uvector.ILispBytevector;
import net.morilib.util.primitive.ByteArrayVector;
import net.morilib.util.uvector.ByteArray;

public class LispS8Vector
extends Atom
implements HomogeneousSignedArray,
ILispBytevector,
Serializable {
    private ByteArray vector;

    private LispS8Vector() {
    }

    public LispS8Vector(byte ... bs) {
        this.vector = ByteArray.newArray(bs);
    }

    public static LispS8Vector malloc(int size) {
        LispS8Vector res = new LispS8Vector();
        res.vector = ByteArray.malloc(size);
        return res;
    }

    private static boolean checkRange(Datum d) {
        if (!(d instanceof LispReal)) {
            return false;
        }
        return ((LispReal)d).inByteRange();
    }

    private static byte[] toByteList(Datum body, LispMessage mesg) {
        ConsIterator itr = new ConsIterator(body);
        ByteArrayVector v = new ByteArrayVector();
        while (itr.hasNext()) {
            Datum d = itr.next();
            if (!LispS8Vector.checkRange(d)) {
                throw mesg.getError("err.uvector.outofrange.s8", d);
            }
            v.add(d.getInt());
        }
        if (!itr.getTerminal().equals(Nil.NIL)) {
            throw mesg.getError("err.list", body);
        }
        return v.toByteArray();
    }

    @Override
    public String print() {
        StringBuilder b = new StringBuilder();
        String d = "";
        b.append("#s8(");
        int i = 0;
        while (i < this.vector.size()) {
            b.append(d);
            b.append(this.vector.getByte(i));
            d = " ";
            ++i;
        }
        b.append(")");
        return b.toString();
    }

    @Override
    public String getResult() {
        return this.print();
    }

    @Override
    public LispString toLispString() {
        return new LispString(this.print());
    }

    @Override
    public boolean equalsArray(Datum d1, Datum d2) {
        if (!(d1 instanceof LispS8Vector)) {
            return false;
        }
        if (!(d2 instanceof LispS8Vector)) {
            return false;
        }
        return ((LispS8Vector)d1).vector.equals(((LispS8Vector)d2).vector);
    }

    @Override
    public LispInteger get(int index) {
        return LispInteger.valueOf(this.vector.getInt(index));
    }

    @Override
    public void set(int index, LispReal x) {
        this.vector.setByte(index, x.castByte());
    }

    @Override
    public int size() {
        return this.vector.size();
    }

    @Override
    public void checkRange(LispReal x, LispMessage mesg) {
        if (!LispS8Vector.checkRange(x)) {
            throw mesg.getError("err.uvector.outofrange.s8", x);
        }
    }

    @Override
    public void set(int index, int x) {
        this.vector.setInt(index, x);
    }

    @Override
    public void set(int index, long x) {
        this.vector.setLong(index, x);
    }

    @Override
    public void set(int index, double x) {
        this.vector.setDouble(index, x);
    }

    public byte[] toArray() {
        return this.vector.toByteArray();
    }

    @Override
    public byte[] toBytes() {
        return this.toArray();
    }

    @Override
    public void setBytes(byte[] b) {
        int i = 0;
        while (i < this.vector.size() && i < b.length) {
            this.vector.setByte(i, b[i]);
            ++i;
        }
    }

    @Override
    public Datum ref(Datum arg, LispMessage mesg) {
        int k = SubrUtils.getSmallInt(arg, mesg);
        if (k < 0 || k >= this.size()) {
            throw mesg.getError("err.accessor.ref.outofrange", arg);
        }
        return this.get(k);
    }

    public static class EqualS8Vector
    extends BinaryArgs {
        @Override
        protected Datum execute(Datum c1a, Datum c2a, Environment env, LispMessage mesg) {
            if (!(c1a instanceof LispS8Vector)) {
                throw mesg.getError("err.uvector.require.s8", c1a);
            }
            if (!(c2a instanceof LispS8Vector)) {
                throw mesg.getError("err.uvector.require.s8", c2a);
            }
            return LispBoolean.getInstance(((LispS8Vector)c1a).vector.equals(((LispS8Vector)c2a).vector));
        }
    }

    public static class IsS8Vector
    extends UnaryArgs {
        @Override
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            return LispBoolean.getInstance(c1a instanceof LispS8Vector);
        }
    }

    public static class ListToS8Vector
    extends UnaryArgs {
        @Override
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            if (c1a instanceof Cons || c1a.equals(Nil.NIL)) {
                return new LispS8Vector(LispS8Vector.toByteList(c1a, mesg));
            }
            throw mesg.getError("err.require.list", c1a);
        }
    }

    public static class MakeS8Vector
    extends Subr {
        private byte[] makeVector(int len, int d) {
            ByteArrayVector b = new ByteArrayVector();
            int i = 0;
            while (i < len) {
                b.add(d);
                ++i;
            }
            return b.toByteArray();
        }

        @Override
        public Datum eval(Datum body, Environment env, LispMessage mesg) {
            List<Datum> lst = LispUtils.consToList(body, mesg);
            if (lst.size() == 1) {
                int t = SubrUtils.getSmallInt(lst.get(0), mesg);
                if (t < 0) {
                    throw mesg.getError("err.require.int.nonnegative", lst.get(0));
                }
                return new LispS8Vector(this.makeVector(t, 0));
            }
            if (lst.size() == 2) {
                int t = SubrUtils.getSmallInt(lst.get(0), mesg);
                if (t < 0) {
                    throw mesg.getError("err.require.int.nonnegative", lst.get(0));
                }
                if (!LispS8Vector.checkRange(lst.get(1))) {
                    throw mesg.getError("err.uvector.outofrange.s8", lst.get(1));
                }
                return new LispS8Vector(this.makeVector(t, lst.get(1).getInt()));
            }
            throw mesg.getError("err.argument", this.symbolName);
        }
    }

    public static class S8Vector
    extends Subr {
        @Override
        public Datum eval(Datum body, Environment env, LispMessage mesg) {
            return new LispS8Vector(LispS8Vector.toByteList(body, mesg));
        }
    }

    public static class S8VectorToList
    extends UnaryArgs {
        @Override
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            if (c1a instanceof LispS8Vector) {
                ConsListBuilder b = new ConsListBuilder();
                LispS8Vector v = (LispS8Vector)c1a;
                int i = 0;
                while (i < v.vector.size()) {
                    b.append(LispInteger.valueOf(v.vector.getByte(i)));
                    ++i;
                }
                return b.get();
            }
            throw mesg.getError("err.uvector.outofrange.s8", c1a);
        }
    }
}

