/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.swing.table;

import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import net.morilib.lisp.Datum;
import net.morilib.lisp.LispVector;
import net.morilib.lisp.swing.LightweightGUIElement;
import net.morilib.lisp.swing.table.AbstractLispTableModel;
import net.morilib.lisp.swing.table.LispMutableTableModel;
import net.morilib.lisp.swing.table.LispVectorTableModel;
import net.morilib.lisp.swing.table.MyJTable;

public class LispJTable
extends LightweightGUIElement {
    JScrollPane component;
    JTable table;

    public LispJTable(JTable table) {
        this.table = table;
        this.component = new JScrollPane(table);
    }

    public LispJTable(Datum d, Datum columnNames) {
        if (d instanceof LispVector) {
            if (!(columnNames instanceof LispVector)) {
                throw new IllegalArgumentException();
            }
            this.table = new MyJTable(new LispVectorTableModel((LispVector)d, (LispVector)columnNames));
        } else {
            this.table = new MyJTable(new LispMutableTableModel(d, columnNames));
        }
        this.component = new JScrollPane(this.table);
    }

    public LispJTable(Datum d) {
        this.table = d instanceof LispVector ? new MyJTable(new LispVectorTableModel((LispVector)d)) : new MyJTable(new LispMutableTableModel(d));
        this.component = new JScrollPane(this.table);
    }

    @Override
    public JComponent getComponent() {
        return this.component;
    }

    @Override
    public Component getAWTComponent() {
        return this.component;
    }

    public int getRowCount() {
        return this.table.getRowCount();
    }

    public int getColumnCount() {
        return this.table.getColumnCount();
    }

    public Datum get(int r, int c) {
        return (Datum)this.table.getValueAt(r, c);
    }

    public void set(int r, int c, Datum d) {
        this.table.setValueAt(d, r, c);
    }

    public void addRow(Datum d) {
        ((AbstractLispTableModel)this.table.getModel()).addRow(d);
    }

    public void insertRow(int r, Datum d) {
        ((AbstractLispTableModel)this.table.getModel()).insertRow(r, d);
    }

    public void removeRow(int r) {
        ((AbstractLispTableModel)this.table.getModel()).removeRow(r);
    }

    public Datum toDatum() {
        return ((AbstractLispTableModel)this.table.getModel()).toList();
    }

    @Override
    public void toDisplayString(StringBuilder buf) {
        buf.append("#<gui-table>");
    }
}

