/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.swing.list;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.Datum;
import net.morilib.lisp.swing.list.AbstractLispJListModel;

public class LispMutableJListModel
extends AbstractLispJListModel {
    private List<Datum> list;

    public LispMutableJListModel() {
        this.list = new ArrayList<Datum>();
    }

    public LispMutableJListModel(Datum d) {
        ConsIterator itr = new ConsIterator(d);
        this.list = new ArrayList<Datum>();
        while (itr.hasNext()) {
            this.list.add(itr.next());
        }
    }

    @Override
    public int getSize() {
        return this.list.size();
    }

    @Override
    public Datum getElementAt(int index) {
        return this.list.get(index);
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.list.contains(o);
    }

    @Override
    public Iterator<Datum> iterator() {
        final Iterator<Datum> itr = this.list.iterator();
        return new Iterator<Datum>(){

            @Override
            public boolean hasNext() {
                return itr.hasNext();
            }

            @Override
            public Datum next() {
                return (Datum)itr.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public boolean add(Datum e) {
        int index = this.list.size();
        this.list.add(e);
        this.fireIntervalAdded(this, index, index);
        return true;
    }

    @Override
    public boolean remove(Object o) {
        int index = this.list.indexOf(o);
        if (index >= 0) {
            this.list.remove(index);
            this.fireIntervalRemoved(this, index, index);
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.list.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends Datum> c) {
        return this.addAll(this.list.size(), c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends Datum> c) {
        if (c.isEmpty()) {
            return false;
        }
        this.list.addAll(c);
        this.fireIntervalAdded(this, index, index + c.size());
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        if (c.isEmpty() || this.list.removeAll(c)) {
            return false;
        }
        this.fireContentsChanged(this, 0, this.list.size());
        return true;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        if (c.isEmpty() || this.list.retainAll(c)) {
            return false;
        }
        this.fireContentsChanged(this, 0, this.list.size());
        return true;
    }

    @Override
    public void clear() {
        int size = this.list.size();
        this.list.clear();
        this.fireIntervalRemoved(this, 0, size);
    }

    @Override
    public Datum set(int index, Datum element) {
        Datum r = this.list.set(index, element);
        this.fireContentsChanged(this, index, index);
        return r;
    }

    @Override
    public void add(int index, Datum e) {
        this.list.add(e);
        this.fireIntervalAdded(this, index, index);
    }

    @Override
    public Datum remove(int index) {
        Datum r = this.list.remove(index);
        this.fireIntervalRemoved(this, index, index);
        return r;
    }

    @Override
    public int indexOf(Object o) {
        return this.list.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.list.lastIndexOf(o);
    }
}

