/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.swing;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.text.AttributeSet;
import javax.swing.text.Keymap;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.Subr;
import net.morilib.lisp.Undef;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.lisp.swing.HasText;
import net.morilib.lisp.swing.ILispLoadableComponent;
import net.morilib.lisp.swing.ILispPrintableComponent;
import net.morilib.lisp.swing.ILispSavableComponent;
import net.morilib.lisp.swing.LightweightGUIElement;
import net.morilib.lisp.swing.LispSwing;
import net.morilib.util.IOs;

public class LispTextPane
extends LightweightGUIElement
implements ILispPrintableComponent,
ILispSavableComponent,
ILispLoadableComponent,
HasText {
    private JTextPane textpane;

    public LispTextPane(JTextPane textpane) {
        this.textpane = textpane;
    }

    @Override
    public Component getAWTComponent() {
        return this.textpane;
    }

    @Override
    public String getText() {
        return this.textpane.getText();
    }

    @Override
    public void setText(String s) {
        this.textpane.setText(s);
    }

    public void addKeyAction(KeyStroke ks, Action a) {
        Keymap km = this.textpane.getKeymap();
        km.addActionForKeyStroke(ks, a);
    }

    public void setDefaultKeyAction(Action a) {
        Keymap km = this.textpane.getKeymap();
        km.setDefaultAction(a);
    }

    public void setStyle(int off, int len, AttributeSet a) {
        this.textpane.getStyledDocument().setCharacterAttributes(off, len, a, true);
    }

    @Override
    public JComponent getComponent() {
        return this.textpane;
    }

    @Override
    public void load(File f, String enc) throws IOException {
        this.textpane.setText(IOs.toString(f, enc));
    }

    @Override
    public void save(File f, String enc) throws IOException {
        IOs.fromString(f, this.textpane.getText(), enc);
    }

    @Override
    public void toDisplayString(StringBuilder buf) {
        buf.append("#<text-pane>");
    }

    public static class AddKeyActionS
    extends Subr {
        @Override
        public Datum eval(Datum body, Environment env, LispMessage mesg) {
            ConsIterator itr = new ConsIterator(body);
            Datum t = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
            Datum k = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
            Datum c = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
            if (t instanceof LispTextPane) {
                Action a = LispSwing.createAction(itr.rest(), body, env, mesg);
                ((LispTextPane)t).addKeyAction(LispSwing.toKeyStroke(k, c, mesg), a);
                return Undef.UNDEF;
            }
            throw mesg.getError("err.swing.require.textpane", body);
        }
    }

    public static class MakeTextPane
    extends Subr {
        @Override
        public Datum eval(Datum body, Environment env, LispMessage mesg) {
            ConsIterator itr = new ConsIterator(body);
            SubrUtils.checkTerminated(itr, body, mesg);
            return new LispTextPane(new JTextPane());
        }
    }

    public static class SetDefaultKeyActionS
    extends Subr {
        @Override
        public Datum eval(Datum body, Environment env, LispMessage mesg) {
            ConsIterator itr = new ConsIterator(body);
            Datum t = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
            if (t instanceof LispTextPane) {
                Action a = LispSwing.createAction(itr.rest(), body, env, mesg);
                ((LispTextPane)t).setDefaultKeyAction(a);
                return Undef.UNDEF;
            }
            throw mesg.getError("err.swing.require.textpane", body);
        }
    }

    public static class SetStyleS
    extends Subr {
        @Override
        public Datum eval(Datum body, Environment env, LispMessage mesg) {
            ConsIterator itr = new ConsIterator(body);
            Datum t = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
            int o = SubrUtils.nextSmallInt((Iterator<Datum>)itr, mesg, body);
            int l = SubrUtils.nextSmallInt((Iterator<Datum>)itr, mesg, body);
            if (t instanceof LispTextPane) {
                AttributeSet a = LispSwing.createAttributeSet(itr.rest(), body, env, mesg);
                ((LispTextPane)t).setStyle(o, l, a);
                return Undef.UNDEF;
            }
            throw mesg.getError("err.swing.require.textpane", body);
        }
    }
}

