/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.subr;

import net.morilib.lisp.Cons;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispInteger;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispNumber;
import net.morilib.lisp.Nil;
import net.morilib.lisp.math.algebra.ILispMultipliable;
import net.morilib.lisp.math.algebra.ILispScalarMultipliable;
import net.morilib.lisp.math.matrix.LispMatrixException;
import net.morilib.lisp.subr.MathOperator1;

public class Mul
extends MathOperator1<ILispMultipliable<?>> {
    @Override
    protected ILispMultipliable calculate(ILispMultipliable o1, ILispMultipliable o2) {
        return o1.mul(o2);
    }

    @Override
    protected LispNumber initValue() {
        return LispInteger.ONE;
    }

    @Override
    public Datum eval(Datum body, Environment env, LispMessage mesg) {
        ILispMultipliable res = null;
        ILispScalarMultipliable re2 = null;
        Datum li = body;
        while (true) {
            if (li instanceof Nil) {
                if (re2 == null) {
                    return res != null ? (Datum)((Object)res) : this.initValue();
                }
                return (Datum)((Object)re2);
            }
            if (!(li instanceof Cons)) break;
            Cons c2 = (Cons)li;
            Datum c2a = c2.getCar();
            if (!(c2a instanceof ILispMultipliable || c2a instanceof ILispScalarMultipliable || c2a instanceof LispNumber)) {
                throw mesg.getError("err.require.number", c2a);
            }
            if (res == null && re2 == null) {
                if (c2a instanceof ILispMultipliable) {
                    res = (ILispMultipliable)((Object)c2a);
                } else {
                    re2 = (ILispScalarMultipliable)((Object)c2a);
                }
            } else if (re2 != null && c2a instanceof LispNumber) {
                re2 = re2.mul((LispNumber)c2a);
            } else {
                if (res != null && res instanceof LispNumber && c2a instanceof ILispScalarMultipliable) {
                    try {
                        re2 = ((ILispScalarMultipliable)((Object)c2a)).mul((LispNumber)res);
                        res = null;
                    }
                    catch (ClassCastException e) {
                        throw mesg.getError("err.math.invalid.scalar", c2a);
                    }
                    catch (IllegalArgumentException e) {
                        throw mesg.getError("err.math.invalid.scalar", c2a);
                    }
                }
                try {
                    res = this.calculate(res, (ILispMultipliable)((Object)c2a));
                }
                catch (ClassCastException e) {
                    throw mesg.getError("err.math.require.sametype", c2a);
                }
                catch (LispMatrixException e) {
                    throw mesg.getError("err.math.require.sametype", c2a);
                }
            }
            li = c2.getCdr();
        }
        throw mesg.getError("err.list");
    }
}

