/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.subr;

import java.util.List;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispBoolean;
import net.morilib.lisp.LispCharacter;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.Subr;

public abstract class CharCompare
extends Subr {
    protected abstract boolean compare(LispCharacter var1, LispCharacter var2);

    @Override
    public Datum eval(Datum body, Environment env, LispMessage mesg) {
        List<Datum> lst = LispUtils.consToList(body, mesg);
        if (lst.size() < 2) {
            throw mesg.getError("err.argument", "char-compare");
        }
        if (!(lst.get(0) instanceof LispCharacter)) {
            throw mesg.getError("err.require.char", lst.get(0));
        }
        LispCharacter prev = (LispCharacter)lst.get(0);
        int i = 1;
        while (i < lst.size()) {
            Datum d = lst.get(i);
            if (d instanceof LispCharacter) {
                if (!this.compare(prev, (LispCharacter)d)) {
                    return LispBoolean.FALSE;
                }
            } else {
                throw mesg.getError("err.require.char", d);
            }
            prev = (LispCharacter)d;
            ++i;
        }
        return LispBoolean.TRUE;
    }
}

