/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.sssp;

import java.util.HashMap;
import java.util.Iterator;
import net.morilib.lisp.Cons;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.Procedure;
import net.morilib.lisp.Subr;
import net.morilib.lisp.sssp.LispCustomTag;
import net.morilib.lisp.sssp.TagTransformer;
import net.morilib.lisp.subr.SubrUtils;

public class MakeCustomTag
extends Subr {
    @Override
    public Datum eval(Datum body, Environment env, LispMessage mesg) {
        ConsIterator itr = new ConsIterator(body);
        HashMap<String, Integer> attrs = new HashMap<String, Integer>();
        HashMap<String, TagTransformer> types = new HashMap<String, TagTransformer>();
        Datum l = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
        if (!(l instanceof Procedure)) {
            throw mesg.getError("err.require.procedure", l);
        }
        int i = 0;
        while (itr.hasNext()) {
            TagTransformer tt;
            Datum a;
            Datum d = itr.next();
            if (d instanceof Cons) {
                a = SubrUtils.cadr(d, mesg);
                Datum t = SubrUtils.cadr(d, mesg);
                tt = TagTransformer.getInstance(t);
                if (tt == null) {
                    throw mesg.getError("err.sss.tagtype.invalid");
                }
            } else {
                a = d;
                tt = TagTransformer.STRING;
            }
            String as = SubrUtils.getSymbolName(a, mesg);
            attrs.put(as, i);
            types.put(as, tt);
            ++i;
        }
        SubrUtils.checkTerminated(itr, body, mesg);
        return new LispCustomTag(attrs, types, (Procedure)((Object)l));
    }
}

