/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.sql;

import java.sql.SQLException;
import net.morilib.lisp.LispException;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispString;
import net.morilib.lisp.condition.LispCompoundCondition;
import net.morilib.lisp.condition.LispCondition;
import net.morilib.lisp.condition.LispSimpleCondition;

public class LispSQLException
extends LispException {
    private static final long serialVersionUID = 1349654199831740484L;
    private static final String ERR_CD = "err.jdbc.sqlerror";
    private SQLException sqlException;

    private LispSQLException(String code, String message, SQLException cause) {
        super(code, message, LispSQLException.makecond(message), cause);
        this.sqlException = cause;
    }

    public static LispSQLException getError(LispMessage mesg, SQLException cause) {
        return new LispSQLException(ERR_CD, mesg.get(ERR_CD), cause);
    }

    private static LispCondition makecond(String message) {
        LispCondition err = LispMessage.getConditionByKey(ERR_CD);
        LispSimpleCondition msg = LispSimpleCondition.newInstance("&message");
        msg.setField("message", new LispString(message));
        return new LispCompoundCondition(err, msg);
    }

    LispSQLException getNextException(LispMessage mesg) {
        return LispSQLException.getError(mesg, this.sqlException.getNextException());
    }

    public int getSQLErrorCode() {
        return this.sqlException.getErrorCode();
    }

    public String getSQLState() {
        return this.sqlException.getSQLState();
    }

    @Override
    public SQLException getException() {
        return this.sqlException;
    }
}

