/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.security.keypair;

import java.io.IOException;
import java.io.Serializable;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;
import java.security.SignedObject;
import java.util.Iterator;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.JavaObjective;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.Subr;
import net.morilib.lisp.security.keypair.LispPrivateKey;
import net.morilib.lisp.security.keypair.LispSignature;
import net.morilib.lisp.security.keypair.LispSignedDatum;
import net.morilib.lisp.subr.SubrUtils;

public class SignDatum
extends Subr {
    @Override
    public Datum eval(Datum body, Environment env, LispMessage mesg) {
        ConsIterator itr = new ConsIterator(body);
        Datum d1 = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
        Datum d2 = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
        String al = LispSignature.nextAlgorithm(itr, env, mesg, body);
        try {
            SignedObject sd;
            SubrUtils.checkTerminated(itr, body, mesg);
            if (!(d2 instanceof LispPrivateKey)) {
                throw mesg.getError("err.keypair.require.key.private", d2);
            }
            if (d1 instanceof Serializable) {
                Signature sg = Signature.getInstance(al);
                sd = new SignedObject((Serializable)((Object)d1), ((LispPrivateKey)d2).key, sg);
            } else {
                if (!(d1 instanceof JavaObjective)) {
                    throw mesg.getError("err.serialize.require.serializable", d1);
                }
                Object o = ((JavaObjective)((Object)d1)).toObject();
                if (o instanceof Serializable) {
                    throw mesg.getError("err.serialize.require.serializable", d1);
                }
                Signature sg = Signature.getInstance(al);
                sd = new SignedObject((Serializable)o, ((LispPrivateKey)d2).key, sg);
            }
            return new LispSignedDatum(sd);
        }
        catch (IOException e) {
            throw mesg.getError("err.io");
        }
        catch (NoSuchAlgorithmException e) {
            throw mesg.getError("err.digest.algorithm.notfound", al);
        }
        catch (InvalidKeyException e) {
            throw mesg.getError("err.keypair.key.invalid", d2);
        }
        catch (SignatureException e) {
            throw new RuntimeException(e);
        }
    }
}

