/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.security.keypair;

import java.io.Serializable;
import java.util.Iterator;
import net.morilib.lisp.Cons;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Datum2;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.Symbol;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.util.Bytes;

public class LispSignature
extends Datum2
implements Serializable {
    private static final Symbol DEF_ALGO_SYM = Symbol.getSymbol("*default-signature-algorithm*");
    private static final String DEF_ALGO = "SHA1withRSA";
    byte[] digest;

    LispSignature(byte[] digest) {
        this.digest = digest;
    }

    public static String hexify(byte[] digest) {
        StringBuilder b = new StringBuilder();
        int i = 0;
        while (i < digest.length) {
            b.append(Integer.toString(Bytes.ubyteToInt(digest[i]), 16));
            ++i;
        }
        return b.toString();
    }

    public static String defaultAlgorithm(Environment env) {
        Cons c;
        Datum d = env.findDatum(DEF_ALGO_SYM);
        if (d instanceof Cons && (c = (Cons)d).getCar() instanceof Symbol) {
            String s = ((Symbol)c.getCar()).getName().toUpperCase();
            if (c.getCdr() instanceof Cons && (c = (Cons)c.getCdr()).getCar() instanceof Symbol) {
                s = String.valueOf(s) + "with";
                s = String.valueOf(s) + ((Symbol)c.getCar()).getName().toUpperCase();
                return s;
            }
        }
        return DEF_ALGO;
    }

    public static String nextAlgorithm(ConsIterator itr, Environment env, LispMessage mesg, Datum body) {
        String st = SubrUtils.nextSymbolName((Iterator<Datum>)itr, null, mesg);
        return st != null ? st : LispSignature.defaultAlgorithm(env);
    }

    public String hexify() {
        StringBuilder b = new StringBuilder();
        int i = 0;
        while (i < this.digest.length) {
            b.append(Integer.toString(Bytes.ubyteToInt(this.digest[i]), 16));
            ++i;
        }
        return b.toString();
    }

    @Override
    public void toDisplayString(StringBuilder buf) {
        buf.append("#<signature>");
    }
}

