/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.security.digest;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispString;
import net.morilib.lisp.file.LispFiles;
import net.morilib.lisp.security.digest.LispMessageDigest;
import net.morilib.lisp.subr.BinaryArgs;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.util.IOs;

public class FileToHexifiedMessageDigest
extends BinaryArgs {
    private static final int BUF_SIZE = 1024;

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Datum execute(Datum c1a, Datum c2a, Environment env, LispMessage mesg) {
        LispString lispString;
        String s = SubrUtils.getString(c1a, mesg);
        String al = SubrUtils.getSymbolName(c2a, mesg);
        BufferedInputStream ins = null;
        byte[] b = new byte[1024];
        try {
            MessageDigest md = MessageDigest.getInstance(al.toUpperCase());
            ins = new BufferedInputStream(new FileInputStream(LispFiles.getFile(env, s)));
            while (true) {
                int sz;
                if ((sz = ((InputStream)ins).read(b)) < 0) {
                    lispString = new LispString(LispMessageDigest.hexify(md.digest()));
                    break;
                }
                md.update(b, 0, sz);
            }
        }
        catch (NoSuchAlgorithmException e) {
            try {
                throw mesg.getError("err.digest.algorithm.notfound", c2a);
                catch (IOException e2) {
                    throw mesg.getError("err.io");
                }
            }
            catch (Throwable throwable) {
                IOs.close(ins);
                throw throwable;
            }
        }
        IOs.close(ins);
        return lispString;
    }
}

