/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.r6rs.io.transcd;

import java.io.IOException;
import net.morilib.lisp.r6rs.io.transcd.InputTranscoder;
import net.morilib.lisp.r6rs.io.transcd.LispEolStyle;

public class NewlineInputTranscoder
implements InputTranscoder {
    private InputTranscoder tr;
    private int[] newline;
    private int ptr;
    private int rdptr;
    private int code;
    private transient int pushbk;

    public NewlineInputTranscoder(InputTranscoder tr, LispEolStyle newline, int code) {
        if (tr == null || newline == null) {
            throw new NullPointerException();
        }
        if (newline.newline == null) {
            throw new IllegalArgumentException();
        }
        if (newline.newline.length == 0) {
            throw new IllegalArgumentException();
        }
        this.tr = tr;
        this.newline = newline.newline;
        this.ptr = 0;
        this.rdptr = newline.newline.length - 1;
        this.code = code;
        this.pushbk = -1;
    }

    @Override
    public int read() throws IOException {
        if (this.rdptr < this.ptr) {
            if (this.rdptr + 1 == this.ptr) {
                this.ptr = 0;
            }
            return this.newline[this.rdptr++];
        }
        if (this.pushbk >= 0) {
            int c = this.pushbk;
            this.pushbk = -1;
            return c;
        }
        int c = this.tr.read();
        if (c == this.newline[this.ptr]) {
            if (++this.ptr == this.newline.length) {
                this.ptr = 0;
                this.rdptr = this.newline.length - 1;
                return this.code;
            }
            return this.read();
        }
        if (this.ptr > 0) {
            this.pushbk = c;
            this.rdptr = 0;
            return this.read();
        }
        return c;
    }

    @Override
    public int read(int[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public int read(int[] b, int off, int len) throws IOException {
        i = off;
        c = -1;
        if (len > 0) ** GOTO lbl8
        throw new IllegalArgumentException();
        while ((c = this.read()) >= 0) {
            b[i] = c;
            ++i;
lbl8:
            // 2 sources

            if (i < off + len) continue;
        }
        return i == off && c < 0 ? -1 : i - off;
    }

    @Override
    public void close() throws IOException {
        this.tr.close();
    }
}

