/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.r6rs.io;

import java.util.Iterator;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.Datum;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.Symbol;
import net.morilib.lisp.SyntaxSimple;
import net.morilib.lisp.r6rs.io.transcd.LispEolStyle;
import net.morilib.lisp.subr.SubrUtils;

public class SynsEolStyle
extends SyntaxSimple {
    private static final Symbol CR = Symbol.getSymbol("cr");
    private static final Symbol LF = Symbol.getSymbol("lf");
    private static final Symbol CRLF = Symbol.getSymbol("crlf");
    private static final Symbol NEL = Symbol.getSymbol("nel");
    private static final Symbol CRNEL = Symbol.getSymbol("crnel");
    private static final Symbol LS = Symbol.getSymbol("ls");
    private static final Symbol NONE = Symbol.getSymbol("none");

    @Override
    public Datum toDatum(Datum body, LispMessage mesg) {
        ConsIterator itr = new ConsIterator(body);
        Datum d = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
        SubrUtils.checkTerminated(itr, body, mesg);
        if (d.equals(CR)) {
            return LispEolStyle.CR;
        }
        if (d.equals(LF)) {
            return LispEolStyle.LF;
        }
        if (d.equals(CRLF)) {
            return LispEolStyle.CRLF;
        }
        if (d.equals(NEL)) {
            return LispEolStyle.NEL;
        }
        if (d.equals(CRNEL)) {
            return LispEolStyle.CRNEL;
        }
        if (d.equals(LS)) {
            return LispEolStyle.LS;
        }
        if (d.equals(NONE)) {
            return LispEolStyle.NONE;
        }
        return LispEolStyle.NONE;
    }
}

