/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.r6rs.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.r6rs.io.transcd.ILispTranscoder;
import net.morilib.lisp.r6rs.io.transcd.OutputTranscoder;
import net.morilib.lisp.r6rs.io.transcd.StringInputTranscoder;
import net.morilib.lisp.r6rs.io.transcd.Transcoders;
import net.morilib.lisp.subr.BinaryArgs;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.lisp.uvector.LispU8Vector;

public class StringToBytevector
extends BinaryArgs {
    @Override
    protected Datum execute(Datum c1a, Datum c2a, Environment env, LispMessage mesg) {
        String s = SubrUtils.getString(c1a, mesg);
        if (!(c2a instanceof ILispTranscoder)) {
            throw mesg.getError("err.io.require.transcoder", c2a);
        }
        try {
            ByteArrayOutputStream ous = new ByteArrayOutputStream();
            StringInputTranscoder tri = new StringInputTranscoder(s);
            OutputTranscoder tro = ((ILispTranscoder)((Object)c2a)).newOutput(ous);
            Transcoders.copyWithClose(tri, tro);
            return new LispU8Vector(ous.toByteArray());
        }
        catch (IOException e) {
            throw mesg.getError("err.io", e.getMessage());
        }
    }
}

