/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.r6rs.io;

import java.io.File;
import java.io.IOException;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispBoolean;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.Subr;
import net.morilib.lisp.file.LispFiles;
import net.morilib.lisp.r6rs.io.LispFileOptions;
import net.morilib.lisp.r6rs.io.LispInputStreamPort;
import net.morilib.lisp.r6rs.io.LispTextualInputPort;
import net.morilib.lisp.r6rs.io.transcd.ILispTranscoder;
import net.morilib.lisp.r6rs.io.transcd.LispBufferMode;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.util.Iterators;

public class OpenFileInputPort
extends Subr {
    @Override
    public Datum eval(Datum body, Environment env, LispMessage mesg) {
        try {
            ConsIterator itr = new ConsIterator(body);
            File fn = LispFiles.nextFile(itr, env, mesg, body);
            Datum op = Iterators.nextIf(itr, LispFileOptions.DEFAULT);
            Datum bm = Iterators.nextIf(itr, LispBufferMode.BLOCK);
            Datum tr = Iterators.nextIf(itr, LispBoolean.FALSE);
            SubrUtils.checkTerminated(itr, body, mesg);
            if (!(op instanceof LispFileOptions)) {
                throw mesg.getError("err.io.require.fileoptions", op);
            }
            if (!(bm instanceof LispBufferMode)) {
                throw mesg.getError("err.io.require.buffermode", bm);
            }
            if (tr.isTrue() && !(tr instanceof ILispTranscoder)) {
                throw mesg.getError("err.io.require.transcoder", tr);
            }
            if (tr.isTrue()) {
                return new LispTextualInputPort(((ILispTranscoder)((Object)tr)).newInput(((LispFileOptions)op).openForInput(fn, mesg)), (ILispTranscoder)((Object)tr));
            }
            return new LispInputStreamPort(((LispFileOptions)op).openForInput(fn, mesg));
        }
        catch (IOException e) {
            throw mesg.getError("err.io", e.getMessage());
        }
    }
}

