/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.r6rs.io;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Iterator;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispBoolean;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.Subr;
import net.morilib.lisp.r6rs.io.LispByteArrayBinaryInputPort;
import net.morilib.lisp.r6rs.io.transcd.ILispTranscoder;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.lisp.uvector.ILispBytevector;
import net.morilib.util.Iterators;

public class OpenBytevectorInputPort
extends Subr {
    @Override
    public Datum eval(Datum body, Environment env, LispMessage mesg) {
        ConsIterator itr = new ConsIterator(body);
        Datum bv = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
        Datum tr = Iterators.nextIf(itr, LispBoolean.FALSE);
        SubrUtils.checkTerminated(itr, body, mesg);
        if (!(bv instanceof ILispBytevector)) {
            throw mesg.getError("err.uvector.require.8", bv);
        }
        if (tr.isTrue() && !(tr instanceof ILispTranscoder)) {
            throw mesg.getError("err.io.require.transcoder", tr);
        }
        if (tr.isTrue()) {
            try {
                return (Datum)((Object)((ILispTranscoder)((Object)tr)).newInput(new ByteArrayInputStream(((ILispBytevector)((Object)bv)).toBytes())));
            }
            catch (IOException e) {
                throw mesg.getError("err.io", e.getMessage());
            }
        }
        return new LispByteArrayBinaryInputPort(((ILispBytevector)((Object)bv)).toBytes());
    }
}

