/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.r6rs.io;

import java.io.File;
import java.io.IOException;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Datum2;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispNotSupportedException;
import net.morilib.lisp.Parser;
import net.morilib.lisp.ReadUnreadable;
import net.morilib.lisp.r6rs.io.ILispTextualInputPort;
import net.morilib.lisp.r6rs.io.LispFileOptions;
import net.morilib.lisp.r6rs.io.transcd.ILispTranscoder;
import net.morilib.lisp.r6rs.io.transcd.InputTranscoder;
import net.morilib.lisp.r6rs.io.transcd.LispBufferMode;
import net.morilib.lisp.r6rs.io.transcd.LookaheadInputTranscoder;
import net.morilib.util.io.UTF16;

public class LispTextualInputPort
extends Datum2
implements ILispTextualInputPort,
ReadUnreadable {
    private ILispTranscoder tf;
    private LookaheadInputTranscoder tr;
    private Parser parser;
    private int unread = -1;

    public LispTextualInputPort(File file, LispFileOptions opts, LispBufferMode bufmode, ILispTranscoder tf, LispMessage mesg) throws IOException {
        this.tf = tf;
        this.tr = new LookaheadInputTranscoder(tf.newInput(opts.openForInput(file, mesg)));
        this.parser = new Parser(this);
    }

    public LispTextualInputPort(InputTranscoder tr, ILispTranscoder tf) {
        this.tf = tf;
        this.tr = new LookaheadInputTranscoder(tr);
        this.parser = new Parser(this);
    }

    @Override
    public void close() throws IOException {
        this.tr.close();
    }

    @Override
    public int getChar() throws IOException {
        if (this.unread < 0) {
            return this.tr.read();
        }
        int r = this.unread;
        this.unread = -1;
        return r;
    }

    @Override
    public int lookaheadChar() throws IOException {
        return this.unread < 0 ? this.tr.lookahead() : this.unread;
    }

    @Override
    public String getString(int n) throws IOException {
        int u;
        int[] b = new int[n];
        if (this.unread >= 0) {
            u = 1;
            b[0] = this.unread;
            this.unread = -1;
        } else {
            u = 0;
        }
        int l = this.tr.read(b, u, b.length - u);
        if (l < 0) {
            return u > 0 ? UTF16.toString(b, 0, u) : null;
        }
        if (l + u < b.length) {
            return UTF16.toString(b, 0, l + u);
        }
        return UTF16.toString(b);
    }

    @Override
    public int getChars(int[] buf, int start, int end) throws IOException {
        int u;
        if (this.unread >= 0) {
            u = 1;
            buf[start] = this.unread;
            this.unread = -1;
        } else {
            u = 0;
        }
        return this.tr.read(buf, start + u, end - start - u);
    }

    @Override
    public String getStringAll() throws IOException {
        int l;
        StringBuilder b = new StringBuilder();
        int[] c = new int[1024];
        if (this.unread >= 0) {
            b.appendCodePoint(this.unread);
            this.unread = -1;
        }
        while ((l = this.tr.read(c)) >= 0) {
            b.append(UTF16.toString(c, 0, l));
        }
        return b.length() != 0 ? b.toString() : null;
    }

    @Override
    public String getLine() throws IOException {
        StringBuilder b = new StringBuilder();
        int c = 0;
        while ((c = this.getChar()) >= 0) {
            if (c == 10) break;
            b.appendCodePoint(c);
            ++c;
        }
        return b.length() != 0 ? b.toString() : null;
    }

    @Override
    public Datum getDatum() throws IOException {
        if (this.parser.isEOF()) {
            return null;
        }
        this.parser.clear();
        this.parser.parse();
        return this.parser.isEOF() ? null : this.parser.getDatum();
    }

    @Override
    public int getc() throws IOException {
        return this.getChar();
    }

    @Override
    public void unread(int c) {
        this.unread = c;
    }

    @Override
    public ILispTranscoder getTranscoder() {
        return this.tf;
    }

    @Override
    public boolean isPortEof() throws IOException {
        return this.tr.lookahead() < 0;
    }

    @Override
    public boolean hasPortPosition() {
        return false;
    }

    @Override
    public Datum getPortPosition() {
        throw new LispNotSupportedException();
    }

    @Override
    public boolean hasSetPortPosition() {
        return false;
    }

    @Override
    public void setPortPosition(Datum pos) {
        throw new LispNotSupportedException();
    }

    @Override
    public void toDisplayString(StringBuilder buf) {
        buf.append("#<textual-input-port>");
    }
}

