/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.r6rs.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.morilib.lisp.Datum2;
import net.morilib.lisp.LispMessage;

public class LispFileOptions
extends Datum2 {
    static final int NO_FAIL = 1;
    static final int NO_CREATE = 2;
    static final int NO_TRUNCATE = 4;
    public static LispFileOptions DEFAULT = new LispFileOptions(0);
    private int options;

    LispFileOptions(int options) {
        this.options = options;
    }

    public OutputStream openForOutput(File file, LispMessage mesg) throws IOException {
        if (file.isFile() && (this.options & 1) != 0) {
            throw mesg.getError("err.io.file.alreadyexists", file.toString());
        }
        if (!file.isFile() && (this.options & 2) != 0) {
            throw mesg.getError("err.io.file.notexist", file.toString());
        }
        return new FileOutputStream(file, (this.options & 4) != 0);
    }

    public InputStream openForInput(File file, LispMessage mesg) throws IOException {
        if (!file.isFile()) {
            throw mesg.getError("err.io.file.notexist", file.toString());
        }
        return new FileInputStream(file);
    }

    @Override
    public void toDisplayString(StringBuilder buf) {
        buf.append("#<file-option");
        if ((this.options & 1) != 0) {
            buf.append(" no-fail");
        }
        if ((this.options & 2) != 0) {
            buf.append(" no-create");
        }
        if ((this.options & 4) != 0) {
            buf.append(" no-truncate");
        }
        buf.append(">");
    }
}

