/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.r6rs.io;

import java.io.IOException;
import java.io.OutputStream;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispInteger;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.Procedure;
import net.morilib.lisp.Scheme;
import net.morilib.lisp.r6rs.io.ILispBinaryOutputPort;
import net.morilib.lisp.r6rs.io.LispCustomOutputPort;
import net.morilib.lisp.r6rs.io.SchlushBinaryPortOutputStream;
import net.morilib.lisp.uvector.LispU8Vector;

public class LispCustomBinaryOutputPort
extends LispCustomOutputPort
implements ILispBinaryOutputPort {
    private Procedure write;

    public LispCustomBinaryOutputPort(Environment env, LispMessage mes, String id, Procedure wr, Procedure ps, Procedure sp, Procedure cl) {
        super(env, mes, id, ps, sp, cl);
        this.write = wr;
    }

    @Override
    public void putByte(int b) throws IOException {
        byte[] c = new byte[]{(byte)b};
        this.putBytes(c, 0, 1);
    }

    @Override
    public void putBytes(byte[] src) throws IOException {
        this.putBytes(src, 0, src.length);
    }

    @Override
    public void putBytes(byte[] src, int start) throws IOException {
        this.putBytes(src, start, src.length);
    }

    @Override
    public void putBytes(byte[] src, int start, int end) throws IOException {
        LispU8Vector b = new LispU8Vector(src);
        Scheme.callva(this.write, this.env, this.mesg, b, LispInteger.valueOf(start), LispInteger.valueOf(end - start));
    }

    @Override
    public OutputStream getOutputStream() {
        return new SchlushBinaryPortOutputStream(this);
    }
}

