/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.r6rs.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispInteger;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.Procedure;
import net.morilib.lisp.Scheme;
import net.morilib.lisp.r6rs.io.ILispBinaryInputPort;
import net.morilib.lisp.r6rs.io.LispCustomInputPort;
import net.morilib.lisp.r6rs.io.SchlushBinaryPortInputStream;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.lisp.uvector.LispU8Vector;
import net.morilib.util.Bytes;

public class LispCustomBinaryInputPort
extends LispCustomInputPort
implements ILispBinaryInputPort {
    private Procedure read;

    public LispCustomBinaryInputPort(Environment env, LispMessage mes, String id, Procedure rd, Procedure ps, Procedure sp, Procedure cl) {
        super(env, mes, id, ps, sp, cl);
        this.read = rd;
    }

    @Override
    public int getByte() throws IOException {
        if (this.lookahead < 0) {
            return -1;
        }
        LispU8Vector b = new LispU8Vector(new byte[1]);
        Datum d = Scheme.callva(this.read, this.env, this.mesg, b, LispInteger.ZERO, LispInteger.ONE);
        int bts = SubrUtils.getSmallInt(d, this.mesg);
        int r = this.lookahead;
        if (bts > 0) {
            this.lookahead = b.get(0).getExactSmallInt();
            return r;
        }
        this.lookahead = -1;
        return -1;
    }

    @Override
    public int lookaheadByte() throws IOException {
        return this.lookahead;
    }

    @Override
    public byte[] getBytes(int n) throws IOException {
        byte[] r = new byte[n];
        return (byte[])(this.getBytes(r, 0, n) >= 0 ? r : null);
    }

    @Override
    public int getBytes(byte[] buf, int start, int end) throws IOException {
        if (this.lookahead < 0) {
            return -1;
        }
        LispU8Vector b = new LispU8Vector(buf);
        Datum d = Scheme.callva(this.read, this.env, this.mesg, b, LispInteger.valueOf(start), LispInteger.valueOf(end - start));
        int bts = SubrUtils.getSmallInt(d, this.mesg);
        if (bts > 0) {
            byte[] c = b.toBytes();
            System.arraycopy(c, start, buf, start + 1, bts - 1);
            buf[start] = (byte)this.lookahead;
            this.lookahead = Bytes.ubyteToInt(c[start + bts - 1]);
            return bts;
        }
        buf[start] = (byte)this.lookahead;
        this.lookahead = -1;
        return 1;
    }

    @Override
    public byte[] getBytesSome() throws IOException {
        return this.getBytes(1024);
    }

    @Override
    public byte[] getBytesAll() throws IOException {
        int l;
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        byte[] c = new byte[1024];
        while ((l = this.getBytes(c, 0, 1024)) >= 0) {
            b.write(c, 0, l);
        }
        return b.toByteArray();
    }

    @Override
    public InputStream getInputStream() {
        return new SchlushBinaryPortInputStream(this);
    }
}

