/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.r6rs.flonum;

import java.math.BigInteger;
import java.util.Iterator;
import net.morilib.lisp.Datum;
import net.morilib.lisp.LispDouble;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.r6rs.flonum.ILispFlonum;

public final class FlonumUtils {
    private static final BigInteger BTWO = BigInteger.valueOf(2L);

    private FlonumUtils() {
    }

    public static double getFlonum(Datum d, LispMessage mesg) {
        if (d instanceof ILispFlonum) {
            return ((ILispFlonum)((Object)d)).getFlonum();
        }
        throw mesg.getError("err.r6rs.require.flonum", d);
    }

    public static double nextFlonum(Iterator<Datum> itr, Datum body, LispMessage mesg) {
        if (itr.hasNext()) {
            return FlonumUtils.getFlonum(itr.next(), mesg);
        }
        throw mesg.getError("err.argument", body);
    }

    public static Datum flonum(double x) {
        return new LispDouble(x);
    }

    public static boolean isInteger(double x) {
        return LispUtils.toIntegerExact(x) != null;
    }

    public static boolean isOdd(double x) {
        BigInteger r = LispUtils.toIntegerExact(x);
        return r != null && r.remainder(BTWO).signum() != 0;
    }

    public static boolean isEven(double x) {
        BigInteger r = LispUtils.toIntegerExact(x);
        return r != null && r.remainder(BTWO).signum() == 0;
    }

    public static double div(double x, double y) {
        if (y == 0.0) {
            return Double.NaN;
        }
        if (Double.isInfinite(x)) {
            return Double.NaN;
        }
        if (y == Double.POSITIVE_INFINITY) {
            return x > 0.0 ? 0.0 : (x < 0.0 ? -0.0 : x);
        }
        if (y == Double.NEGATIVE_INFINITY) {
            return x > 0.0 ? -0.0 : (x < 0.0 ? 0.0 : -x);
        }
        if (Double.isNaN(x) || Double.isNaN(y)) {
            return Double.NaN;
        }
        if (y > 0.0) {
            return Math.floor(x / y);
        }
        return Math.ceil(x / y);
    }

    public static double mod(double x, double y) {
        if (y == 0.0) {
            return Double.NaN;
        }
        if (Double.isInfinite(x)) {
            return Double.NaN;
        }
        if (y == Double.POSITIVE_INFINITY) {
            return x >= 0.0 ? x : Double.POSITIVE_INFINITY;
        }
        if (y == Double.NEGATIVE_INFINITY) {
            return x >= 0.0 ? x : Double.POSITIVE_INFINITY;
        }
        if (Double.isNaN(x) || Double.isNaN(y)) {
            return Double.NaN;
        }
        if (y > 0.0) {
            return x - y * Math.floor(x / y);
        }
        return x - y * Math.ceil(x / y);
    }

    public static double div0(double x, double y) {
        if (y == 0.0) {
            return Double.NaN;
        }
        if (Double.isInfinite(x)) {
            return Double.NaN;
        }
        if (y == Double.POSITIVE_INFINITY) {
            return x > 0.0 ? 0.0 : (x < 0.0 ? -0.0 : x);
        }
        if (y == Double.NEGATIVE_INFINITY) {
            return x > 0.0 ? -0.0 : (x < 0.0 ? 0.0 : -x);
        }
        if (Double.isNaN(x) || Double.isNaN(y)) {
            return Double.NaN;
        }
        return FlonumUtils.truncate(x / y);
    }

    public static double mod0(double x, double y) {
        if (y == 0.0) {
            return Double.NaN;
        }
        if (Double.isInfinite(x)) {
            return Double.NaN;
        }
        if (y == Double.POSITIVE_INFINITY) {
            return x;
        }
        if (y == Double.NEGATIVE_INFINITY) {
            return -x;
        }
        if (Double.isNaN(x) || Double.isNaN(y)) {
            return Double.NaN;
        }
        return x - y * FlonumUtils.truncate(x / y);
    }

    public static double getNumerator(double x) {
        if (x == 0.0) {
            return x;
        }
        if (Double.isInfinite(x)) {
            return x;
        }
        if (Double.isNaN(x)) {
            return Double.NaN;
        }
        return LispDouble.toExact(x).getNumerator().doubleValue();
    }

    public static double getDenominator(double x) {
        if (x == 0.0) {
            return 1.0;
        }
        if (Double.isInfinite(x)) {
            return 1.0;
        }
        if (Double.isNaN(x)) {
            return Double.NaN;
        }
        return LispDouble.toExact(x).getDenominator().doubleValue();
    }

    public static double truncate(double x) {
        return x > 0.0 ? Math.floor(x) : Math.ceil(x);
    }
}

