/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.r6rs.flonum;

import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.Subr;
import net.morilib.lisp.r6rs.flonum.FlonumUtils;
import net.morilib.lisp.subr.SubrUtils;

public abstract class AbstractFlonumOp
extends Subr {
    protected abstract double op(double var1, double var3);

    protected abstract double init();

    @Override
    public Datum eval(Datum body, Environment env, LispMessage mesg) {
        ConsIterator itr = new ConsIterator(body);
        double r = this.init();
        while (itr.hasNext()) {
            double s = FlonumUtils.nextFlonum(itr, body, mesg);
            if (Double.isNaN(s)) {
                return FlonumUtils.flonum(s);
            }
            r = this.op(r, s);
        }
        SubrUtils.checkTerminated(itr, body, mesg);
        return FlonumUtils.flonum(r);
    }
}

