/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.r6rs.bytevector;

import java.util.Iterator;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispString;
import net.morilib.lisp.Subr;
import net.morilib.lisp.Symbol;
import net.morilib.lisp.r6rs.bytevector.LispBytevector;
import net.morilib.lisp.r6rs.bytevector.SynEndianness;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.util.Endianness2;
import net.morilib.util.Iterators;

public class Utf32ToString
extends Subr {
    @Override
    public Datum eval(Datum body, Environment env, LispMessage mesg) {
        StringBuilder b = new StringBuilder();
        ConsIterator itr = new ConsIterator(body);
        LispBytevector v = LispBytevector.datumToBytevector(SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body), mesg);
        Datum d2 = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
        Datum d3 = Iterators.nextIf(itr);
        SubrUtils.checkTerminated(itr, body, mesg);
        if (!(d2 instanceof Symbol)) {
            throw mesg.getError("err.r6rs.require.endianness", d2);
        }
        Endianness2 e = SynEndianness.getEndianness(d2, mesg);
        int f = 0;
        int t = v.length();
        if ((t - f) % 4 != 0) {
            throw mesg.getError("err.r6rs.range.mustbemultiple");
        }
        if (!(d3 != null && d3.isTrue() || t - f < 4)) {
            switch ((int)Endianness2.BIG.read(v.vector, 0, 4)) {
                case 65279: {
                    e = Endianness2.BIG;
                    f += 4;
                    break;
                }
                case -131072: {
                    e = Endianness2.LITTLE;
                    f += 4;
                    break;
                }
            }
        }
        int k = f;
        while (k < t) {
            b.appendCodePoint((int)e.read(v.vector, k, 4));
            k += 4;
        }
        return new LispString(b.toString());
    }
}

