/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.r6rs.bytevector;

import java.nio.ByteOrder;
import java.util.Iterator;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.Datum;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.Symbol;
import net.morilib.lisp.SyntaxSimple;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.util.Endianness2;

public class SynEndianness
extends SyntaxSimple {
    public static final Datum BIG_ENDIAN = Symbol.getSymbol("big");
    public static final Datum LITTLE_ENDIAN = Symbol.getSymbol("little");

    static Endianness2 getEndianness(Datum d, LispMessage mesg) {
        if (d.equals(BIG_ENDIAN)) {
            return Endianness2.BIG;
        }
        if (d.equals(LITTLE_ENDIAN)) {
            return Endianness2.LITTLE;
        }
        throw mesg.getError("err.r6rs.endianness.invalid", d);
    }

    static Endianness2 getNative() {
        return ByteOrder.nativeOrder().equals(ByteOrder.BIG_ENDIAN) ? Endianness2.BIG : Endianness2.LITTLE;
    }

    public static Datum getNativeSymbol() {
        return ByteOrder.nativeOrder().equals(ByteOrder.BIG_ENDIAN) ? BIG_ENDIAN : LITTLE_ENDIAN;
    }

    @Override
    public Datum toDatum(Datum body, LispMessage mesg) {
        ConsIterator itr = new ConsIterator(body);
        String s = SubrUtils.nextSymbolName((Iterator<Datum>)itr, mesg, body);
        SubrUtils.checkTerminated(itr, body, mesg);
        if (s.equals("big")) {
            return BIG_ENDIAN;
        }
        if (s.equals("little")) {
            return LITTLE_ENDIAN;
        }
        throw mesg.getError("err.r6rs.endianness.invalid", s);
    }
}

