/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.painter;

import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;
import net.morilib.lisp.painter.SchlushFont;
import net.morilib.lisp.painter.SchlushFrame;
import net.morilib.lisp.painter.drawer.CoordinateMap;
import net.morilib.lisp.painter.drawer.Drawer;
import net.morilib.lisp.painter.geom.MutablePoint2D;
import net.morilib.lisp.swing.GUIElement;

public abstract class SchlushPanelFrame
extends GUIElement
implements SchlushFrame {
    protected CoordinateMap coordinate;
    private List<SchlushFrame.ImageInfo> images = new ArrayList<SchlushFrame.ImageInfo>();
    private List<Drawer> drawers = new ArrayList<Drawer>();
    private List<Drawer> bgdrawers = new ArrayList<Drawer>();
    private Map<Ipt, Rectangle2D> queue = new HashMap<Ipt, Rectangle2D>();

    public SchlushPanelFrame(CoordinateMap coordinate) {
        this.coordinate = coordinate;
    }

    public SchlushPanelFrame() {
        this(null);
    }

    protected abstract void loadImage(Image var1) throws InterruptedException;

    public JPanel createPanel() {
        return new SPanel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addImage(SchlushFrame.ImageInfo img) throws InterruptedException {
        Image img2 = null;
        if (this.coordinate != null) {
            MutablePoint2D ps = this.coordinate.transformSize(this.getWidth(), this.getHeight(), img.sx, img.sy);
            if (ps.getXInt() > 0 && ps.getYInt() > 0) {
                img2 = img.img.getScaledInstance(ps.getXInt(), ps.getYInt(), 4);
            }
        } else if ((int)img.sx > 0 && (int)img.sy > 0) {
            img2 = img.img.getScaledInstance((int)img.sx, (int)img.sy, 4);
        }
        if (img2 != null) {
            this.loadImage(img.img);
            List<SchlushFrame.ImageInfo> list = this.images;
            synchronized (list) {
                this.images.add(new SchlushFrame.ImageInfo(img2, img.x, img.y, img.sx, img.sy));
            }
        }
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addDrawer(Drawer drawer) {
        List<Drawer> list = this.drawers;
        synchronized (list) {
            this.drawers.add(drawer);
        }
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addBackgroundDrawer(Drawer drawer) {
        List<Drawer> list = this.bgdrawers;
        synchronized (list) {
            this.bgdrawers.add(drawer);
        }
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearScreen() {
        List<Object> list = this.images;
        synchronized (list) {
            this.images.clear();
        }
        list = this.drawers;
        synchronized (list) {
            this.drawers.clear();
        }
        this.repaint();
    }

    @Override
    public CoordinateMap getCoordinate() {
        return this.coordinate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Rectangle2D calculateFontBounds(String str, SchlushFont font) {
        Ipt ipt = new Ipt();
        ipt.str = str;
        ipt.fnt = font.font;
        Map<Ipt, Rectangle2D> map = this.queue;
        synchronized (map) {
            this.queue.put(ipt, null);
            this.repaint();
            try {
                if (this.queue.get(ipt) == null) {
                    this.queue.wait();
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        return this.queue.remove(ipt);
    }

    @Override
    public double transformX(double x) {
        return this.coordinate.transform(this.getWidth(), this.getHeight(), x, 0.0).getX();
    }

    @Override
    public double transformY(double y) {
        return this.coordinate.transform(this.getWidth(), this.getHeight(), 0.0, y).getY();
    }

    @Override
    public double invertX(int x) {
        return this.coordinate.invert(this.getWidth(), this.getHeight(), x, 0.0).getX();
    }

    @Override
    public double invertY(int y) {
        return this.coordinate.invert(this.getWidth(), this.getHeight(), 0.0, y).getY();
    }

    @Override
    public void toDisplayString(StringBuilder buf) {
        buf.append("#<swing-panel>");
    }

    private class Ipt {
        private String str;
        private Font fnt;

        private Ipt() {
        }
    }

    private class SPanel
    extends JPanel {
        private static final long serialVersionUID = 8388728689806126886L;

        private SPanel() {
        }

        private void paintImage(Graphics g, SchlushFrame.ImageInfo info) {
            if (SchlushPanelFrame.this.coordinate != null) {
                MutablePoint2D p0 = SchlushPanelFrame.this.coordinate.transform(this.getWidth(), this.getHeight(), info.x, info.y);
                MutablePoint2D ps = SchlushPanelFrame.this.coordinate.transformSize(this.getWidth(), this.getHeight(), info.sx, info.sy);
                g.drawImage(info.img, p0.getXInt(), p0.getYInt() - ps.getYInt(), this);
            } else {
                g.drawImage(info.img, (int)info.x, (int)info.y, this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void paintComponent(Graphics g2) {
            Graphics g = g2;
            super.paintComponent(g);
            Object object = SchlushPanelFrame.this.bgdrawers;
            synchronized (object) {
                for (Drawer drawer : SchlushPanelFrame.this.bgdrawers) {
                    drawer.draw(g, this.getWidth(), this.getHeight(), SchlushPanelFrame.this.coordinate);
                }
            }
            object = SchlushPanelFrame.this.images;
            synchronized (object) {
                for (SchlushFrame.ImageInfo info : SchlushPanelFrame.this.images) {
                    this.paintImage(g, info);
                }
            }
            object = SchlushPanelFrame.this.drawers;
            synchronized (object) {
                for (Drawer drawer : SchlushPanelFrame.this.drawers) {
                    drawer.draw(g, this.getWidth(), this.getHeight(), SchlushPanelFrame.this.coordinate);
                }
            }
            object = SchlushPanelFrame.this.queue;
            synchronized (object) {
                Graphics2D g2d = (Graphics2D)g;
                for (Map.Entry entry : SchlushPanelFrame.this.queue.entrySet()) {
                    TextLayout tl = new TextLayout(((Ipt)entry.getKey()).str, ((Ipt)entry.getKey()).fnt, g2d.getFontRenderContext());
                    entry.setValue(tl.getBounds());
                }
                SchlushPanelFrame.this.queue.notifyAll();
            }
        }
    }
}

