/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.net.uri;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.Subr;
import net.morilib.lisp.net.uri.LispURI;
import net.morilib.lisp.subr.SubrUtils;

public class MakeUri
extends Subr {
    @Override
    public Datum eval(Datum body, Environment env, LispMessage mesg) {
        List<Datum> l = LispUtils.consToList(body, mesg);
        try {
            switch (l.size()) {
                case 1: {
                    String uri = SubrUtils.getString(l.get(0), mesg);
                    return new LispURI(new URI(uri));
                }
                case 3: {
                    String scheme = SubrUtils.getString(l.get(0), mesg);
                    String ssp = SubrUtils.getString(l.get(1), mesg);
                    String fragment = SubrUtils.getString(l.get(2), mesg);
                    return new LispURI(new URI(scheme, ssp, fragment));
                }
                case 4: {
                    String scheme = SubrUtils.getString(l.get(0), mesg);
                    String host = SubrUtils.getString(l.get(1), mesg);
                    String path = SubrUtils.getString(l.get(2), mesg);
                    String fragment = SubrUtils.getString(l.get(3), mesg);
                    return new LispURI(new URI(scheme, host, path, fragment));
                }
                case 5: {
                    String scheme = SubrUtils.getString(l.get(0), mesg);
                    String authority = SubrUtils.getString(l.get(1), mesg);
                    String path = SubrUtils.getString(l.get(2), mesg);
                    String query = SubrUtils.getString(l.get(3), mesg);
                    String fragment = SubrUtils.getString(l.get(4), mesg);
                    return new LispURI(new URI(scheme, authority, path, query, fragment));
                }
                case 7: {
                    String scheme = SubrUtils.getString(l.get(0), mesg);
                    String userInfo = SubrUtils.getString(l.get(3), mesg);
                    String host = SubrUtils.getString(l.get(1), mesg);
                    int port = SubrUtils.getSmallInt(l.get(3), mesg);
                    String path = SubrUtils.getString(l.get(2), mesg);
                    String query = SubrUtils.getString(l.get(3), mesg);
                    String fragment = SubrUtils.getString(l.get(3), mesg);
                    return new LispURI(new URI(scheme, userInfo, host, port, path, query, fragment));
                }
            }
            throw mesg.getError("err.argument", body);
        }
        catch (URISyntaxException e) {
            throw mesg.getError("err.net.uri.invalid");
        }
    }
}

