/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.net.misc;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispBoolean;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.Subr;
import net.morilib.lisp.net.SubrNetUtils;
import net.morilib.lisp.r6rs.io.LispFileOptions;
import net.morilib.lisp.r6rs.io.LispInputStreamPort;
import net.morilib.lisp.r6rs.io.LispTextualInputPort;
import net.morilib.lisp.r6rs.io.transcd.ILispTranscoder;
import net.morilib.lisp.r6rs.io.transcd.LispBufferMode;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.net.misc.TCPServiceInputStream;
import net.morilib.util.Iterators;

public class OpenDaytimeInputPort
extends Subr {
    @Override
    public Datum eval(Datum body, Environment env, LispMessage mesg) {
        try {
            ConsIterator itr = new ConsIterator(body);
            InetAddress ip = SubrNetUtils.nextAddress(itr, body, mesg);
            int pt = 13;
            Datum op = Iterators.nextIf(itr, LispFileOptions.DEFAULT);
            Datum bm = Iterators.nextIf(itr, LispBufferMode.BLOCK);
            Datum tr = Iterators.nextIf(itr, LispBoolean.FALSE);
            SubrUtils.checkTerminated(itr, body, mesg);
            if (!(op instanceof LispFileOptions)) {
                throw mesg.getError("err.io.require.fileoptions", op);
            }
            if (!(bm instanceof LispBufferMode)) {
                throw mesg.getError("err.io.require.buffermode", bm);
            }
            if (tr.isTrue() && !(tr instanceof ILispTranscoder)) {
                throw mesg.getError("err.io.require.transcoder", tr);
            }
            TCPServiceInputStream ins = new TCPServiceInputStream(ip, pt);
            if (tr.isTrue()) {
                return new LispTextualInputPort(((ILispTranscoder)((Object)tr)).newInput(ins), (ILispTranscoder)((Object)tr));
            }
            return new LispInputStreamPort(ins);
        }
        catch (UnknownHostException e) {
            throw mesg.getError("err.net.unknownhost");
        }
        catch (IOException e) {
            throw mesg.getError("err.io", e.getMessage());
        }
    }
}

