/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.matrix;

import java.io.Serializable;
import java.util.Arrays;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Undef;
import net.morilib.lisp.matrix.AbstractLispArrayDatumMatrix;
import net.morilib.lisp.matrix.ILispDatumMatrix;

public class LispDatumMatrix
extends AbstractLispArrayDatumMatrix
implements Serializable {
    private Datum[] array;

    public LispDatumMatrix(int rows, int columns) {
        this(rows, columns, Undef.UNDEF);
    }

    public LispDatumMatrix(int rows, int columns, Datum fill) {
        if (rows <= 0 || columns <= 0) {
            throw new IllegalArgumentException();
        }
        this.array = new Datum[rows * columns];
        this.rows = rows;
        this.columns = columns;
        Arrays.fill(this.array, fill);
    }

    public LispDatumMatrix(LispDatumMatrix m) {
        this.array = new Datum[m.rows * m.columns];
        this.rows = m.rows;
        this.columns = m.columns;
        System.arraycopy(m.array, 0, this.array, 0, this.array.length);
    }

    public LispDatumMatrix(ILispDatumMatrix m) {
        this.array = new Datum[m.rowSize() * m.columnSize()];
        this.rows = m.rowSize();
        this.columns = m.columnSize();
        int i = 0;
        while (i < m.rowSize()) {
            int j = 0;
            while (j < m.columnSize()) {
                this.set(i, j, m.get(i, j));
                ++j;
            }
            ++i;
        }
    }

    @Override
    protected Datum array(int index) {
        return this.array[index];
    }

    @Override
    protected void arrayset(int index, Datum x) {
        this.array[index] = x;
    }

    @Override
    protected void arraycopy(int srcPos, Object dest, int destPos, int len) {
        System.arraycopy(this.array, srcPos, dest, destPos, len);
    }

    @Override
    protected LispDatumMatrix prototype() {
        return new LispDatumMatrix(this.rows, this.columns);
    }

    @Override
    protected AbstractLispArrayDatumMatrix prototype(int rows, int columns) {
        return new LispDatumMatrix(rows, columns);
    }

    @Override
    public LispDatumMatrix clone() {
        return new LispDatumMatrix(this);
    }
}

