/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.math.stat;

import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispDouble;
import net.morilib.lisp.LispInteger;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.Subr;
import net.morilib.lisp.math.ILispQuantity;
import net.morilib.lisp.math.ILispQuantityFactory;

public class GeometricMean
extends Subr {
    @Override
    public Datum eval(Datum body, Environment env, LispMessage mesg) {
        ConsIterator itr = new ConsIterator(body);
        ILispQuantityFactory f = null;
        double r = 0.0;
        int n = 0;
        while (itr.hasNext()) {
            ILispQuantity q;
            Datum d = itr.next();
            if (!(d instanceof ILispQuantity)) {
                throw mesg.getError("err.stat.require.quantity", d);
            }
            if (f == null) {
                q = (ILispQuantity)((Object)d);
                f = q.factory();
                r = Math.log(q.getReal().doubleValue());
            } else {
                q = (ILispQuantity)((Object)d);
                if (!f.equals(q.factory())) {
                    throw mesg.getError("err.stat.require.samequantity", d);
                }
                r += Math.log(q.getReal().doubleValue());
            }
            ++n;
        }
        if (f == null) {
            return LispInteger.ZERO;
        }
        r = Math.exp(r / (double)n);
        return (Datum)((Object)f.getInstance(new LispDouble(r)));
    }
}

